/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowSubtitleFormatFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowSubtitleFormatFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallSubtitleFormatArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallSubtitleFormatArray());
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<String> epCodecs = episode.getMediaInfoSubtitleCodecList();
            for (String sel : selectedItems) {
                if (!(invert ^ epCodecs.contains(sel))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitleformat"));
    }

    @Override
    public String getId() {
        return "tvShowSubtitleFormat";
    }

    private void buildAndInstallSubtitleFormatArray() {
        HashSet<String> subtitleFormatsInEpisodes = new HashSet<String>(this.tvShowList.getSubtitleFormatsInEpisodes());
        if (!SetUtils.equals(this.oldValues, subtitleFormatsInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(subtitleFormatsInEpisodes);
            List<String> sortedSubtitleFormats = ListUtils.asSortedList(subtitleFormatsInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedSubtitleFormats));
        }
    }
}

