/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieHDRFormatFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieHDRFormatFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallHdrFormatArray();
        EventBus.registerListener("movies-ui", event -> this.buildAndInstallHdrFormatArray());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.hdrformat"));
    }

    @Override
    public String getId() {
        return "movieHdrFormat";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        if (selectedItems.isEmpty() && movie.getVideoHDRFormat().isEmpty()) {
            return true;
        }
        for (String sel : selectedItems) {
            if (movie.getVideoHDRFormat().contains(sel)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    public void buildAndInstallHdrFormatArray() {
        HashSet<String> hdrFormatsInMovies = new HashSet<String>(this.movieList.getHDRFormatInMovies());
        if (!SetUtils.equals(this.oldValues, hdrFormatsInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(hdrFormatsInMovies);
            List<String> sortedHdrFormats = ListUtils.asSortedList(hdrFormatsInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedHdrFormats));
        }
    }
}

