/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Path;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class DebugLoadMovieAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugLoadMovieAction.class);

    public DebugLoadMovieAction() {
        this.putValue("Name", TmmResourceBundle.getString("debug.entity.load"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        Path file = TmmUIHelper.selectFile(TmmResourceBundle.getString("debug.entity.load"), ".", new FileNameExtensionFilter("User submitted JSON files", "json"));
        if (file != null && Utils.isRegularFile(file)) {
            try {
                String json = Utils.readFileToString(file);
                MovieModuleManager.getInstance().load(json);
            }
            catch (IOException io) {
                LOGGER.error("Error loading movie into DB: {}", (Object)io.getMessage(), (Object)io);
            }
        }
    }
}

