/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import ca.odell.glazedlists.EventList;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmEditorTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;

public abstract class PostProcessTable
extends TmmEditorTable {
    protected final EventList<PostProcess> postProcessList;

    public PostProcessTable(EventList<PostProcess> postProcesses) {
        this.postProcessList = postProcesses;
        this.setModel((TableModel)((Object)new TmmTableModel<PostProcess>(this.postProcessList, new PostProcessTableFormat())));
        this.adjustColumnPreferredWidths(3);
    }

    private static class PostProcessTableFormat
    extends TmmTableFormat<PostProcess> {
        private PostProcessTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("Settings.processname"), "name", PostProcess::getName, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.path"), "path", PostProcess::getPath, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("Settings.commandname"), "command", PostProcess::getCommand, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("Button.edit"), "edit", postProcess -> IconManager.EDIT, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.EDIT_HEADER);
            this.addColumn(col);
        }
    }
}

