/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class LanguageUtils {
    public static final Map<String, Locale> KEY_TO_LOCALE_MAP;
    public static final Map<String, Locale> KEY_TO_COUNTRY_LOCALE_MAP;
    public static final Map<String, Integer> MONTH_REGIONAL_TO_NUM;
    private static final Map<Locale, String> ISO_639_2B_EXCEPTIONS;

    private LanguageUtils() {
        throw new IllegalAccessError();
    }

    public static void init() {
    }

    private static Map<Locale, String> createIso6392BExceptions() {
        HashMap<Locale, String> exceptions = new HashMap<Locale, String>();
        exceptions.put(Locale.forLanguageTag("sq"), "alb");
        exceptions.put(Locale.forLanguageTag("hy"), "arm");
        exceptions.put(Locale.forLanguageTag("eu"), "baq");
        exceptions.put(Locale.forLanguageTag("my"), "bur");
        exceptions.put(Locale.forLanguageTag("zh"), "chi");
        exceptions.put(Locale.forLanguageTag("cs"), "cze");
        exceptions.put(Locale.forLanguageTag("nl"), "dut");
        exceptions.put(Locale.forLanguageTag("fr"), "fre");
        exceptions.put(Locale.forLanguageTag("de"), "ger");
        exceptions.put(Locale.forLanguageTag("ka"), "geo");
        exceptions.put(Locale.forLanguageTag("el"), "gre");
        exceptions.put(Locale.forLanguageTag("is"), "ice");
        exceptions.put(Locale.forLanguageTag("mk"), "mac");
        exceptions.put(Locale.forLanguageTag("mi"), "mao");
        exceptions.put(Locale.forLanguageTag("ms"), "may");
        exceptions.put(Locale.forLanguageTag("fa"), "per");
        exceptions.put(Locale.forLanguageTag("ro"), "rum");
        exceptions.put(Locale.forLanguageTag("sk"), "slo");
        exceptions.put(Locale.forLanguageTag("bo"), "tib");
        exceptions.put(Locale.forLanguageTag("cy"), "wel");
        return exceptions;
    }

    private static LinkedHashMap<String, Locale> generateLanguageArray() {
        Locale base;
        HashMap<String, Locale> langArray = new HashMap<String, Locale>();
        LinkedHashMap<String, Locale> sortedMap = new LinkedHashMap<String, Locale>();
        Locale intl = Locale.ENGLISH;
        for (String langu : Locale.getISOLanguages()) {
            base = new Locale(langu);
            langArray.put(base.getISO3Language().toLowerCase(Locale.ROOT), base);
            langArray.put(LanguageUtils.getIso3BLanguage(base).toLowerCase(Locale.ROOT), base);
            langArray.put(langu.toLowerCase(Locale.ROOT), base);
            langArray.putIfAbsent(base.getDisplayLanguage().toLowerCase(Locale.ROOT), base);
            langArray.putIfAbsent(base.getDisplayLanguage(intl).toLowerCase(Locale.ROOT), base);
            try {
                langArray.putIfAbsent(base.getDisplayLanguage(intl).substring(0, 3).toLowerCase(Locale.ROOT), base);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String displayLangu : Locale.getISOLanguages()) {
                try {
                    String alternativeLanguage = base.getDisplayLanguage(new Locale(displayLangu));
                    if (alternativeLanguage.isEmpty()) continue;
                    langArray.putIfAbsent(alternativeLanguage.toLowerCase(Locale.ROOT), base);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        langArray.put("mis", new Locale("mis"));
        langArray.put("mul", new Locale("mul"));
        langArray.put("und", new Locale("und"));
        langArray.put("zxx", new Locale("zxx"));
        langArray.put("pb", new Locale("pt", "BR"));
        langArray.put("pob", new Locale("pt", "BR"));
        langArray.put("ptb", new Locale("pt", "BR"));
        langArray.put("pt-br", new Locale("pt", "BR"));
        langArray.put("chs", Locale.SIMPLIFIED_CHINESE);
        langArray.put("cht", Locale.TRADITIONAL_CHINESE);
        langArray.put("zh-chs", Locale.SIMPLIFIED_CHINESE);
        langArray.put("zh-cht", Locale.TRADITIONAL_CHINESE);
        for (Locale locale : Locale.getAvailableLocales()) {
            base = new Locale(locale.getLanguage());
            langArray.putIfAbsent(locale.toLanguageTag().toLowerCase(Locale.ROOT), base);
        }
        LinkedList keys = new LinkedList(langArray.keySet());
        keys.sort((s1, s2) -> s2.length() - s1.length());
        for (String key : keys) {
            if (key.isEmpty()) continue;
            sortedMap.put(key, (Locale)langArray.get(key));
        }
        return sortedMap;
    }

    private static LinkedHashMap<String, Locale> generateCountryArray() {
        HashMap<String, Locale> langArray = new HashMap<String, Locale>();
        LinkedHashMap<String, Locale> sortedMap = new LinkedHashMap<String, Locale>();
        Locale intl = Locale.ENGLISH;
        for (String cc : Locale.getISOCountries()) {
            Locale l = new Locale("", cc);
            langArray.put(l.getDisplayCountry(), l);
            langArray.put(l.getDisplayCountry(intl), l);
            for (String displayLangu : Locale.getISOLanguages()) {
                try {
                    String alternativeLanguage = l.getDisplayCountry(new Locale(displayLangu));
                    if (alternativeLanguage.isEmpty()) continue;
                    langArray.putIfAbsent(alternativeLanguage, l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            langArray.put(l.getCountry().toLowerCase(Locale.ROOT), l);
            langArray.put(l.getISO3Country().toLowerCase(Locale.ROOT), l);
        }
        LinkedList keys = new LinkedList(langArray.keySet());
        Collections.sort(keys, (s1, s2) -> s2.length() - s1.length());
        for (String key : keys) {
            if (key.isEmpty()) continue;
            sortedMap.put(key.toLowerCase(Locale.ROOT), (Locale)langArray.get(key));
        }
        return sortedMap;
    }

    private static Map<String, Integer> generateMonthNameArray() {
        HashMap<String, Integer> months = new HashMap<String, Integer>();
        Calendar cal = Calendar.getInstance();
        for (Locale loc : Locale.getAvailableLocales()) {
            SimpleDateFormat df = new SimpleDateFormat("MMM", loc);
            SimpleDateFormat df2 = new SimpleDateFormat("MMMM", loc);
            for (int i = 0; i < 12; ++i) {
                cal.set(2, i);
                String monthShort = df.format(cal.getTime());
                months.put(monthShort, i + 1);
                String monthLong = df2.format(cal.getTime());
                months.put(monthLong, i + 1);
            }
        }
        return months;
    }

    public static String getIso3BLanguage(Locale locale) {
        if (ISO_639_2B_EXCEPTIONS.containsKey(locale)) {
            return ISO_639_2B_EXCEPTIONS.get(locale);
        }
        if ("pt-BR".equals(locale.toLanguageTag())) {
            return "pob";
        }
        return locale.getISO3Language();
    }

    public static String getIso3BLanguage(String language) {
        return LanguageUtils.getIso3BLanguage(Locale.forLanguageTag(language));
    }

    public static String getIso3LanguageFromLocalizedString(String text) {
        Locale l = KEY_TO_LOCALE_MAP.get(text.toLowerCase(Locale.ROOT));
        if (l == null) {
            l = KEY_TO_LOCALE_MAP.get(text.replace("_", "-").toLowerCase(Locale.ROOT));
        }
        if (l != null) {
            if ("pt-BR".equals(l.toLanguageTag())) {
                return "pob";
            }
            return l.getISO3Language();
        }
        return "";
    }

    public static String getIso3Language(Locale locale) {
        if (locale != null) {
            if ("pt-BR".equals(locale.toLanguageTag())) {
                return "pob";
            }
            return locale.getISO3Language();
        }
        return "";
    }

    public static String getIso3BLanguageFromLocalizedString(String text) {
        Locale l = KEY_TO_LOCALE_MAP.get(text.toLowerCase(Locale.ROOT));
        if (l == null) {
            l = KEY_TO_LOCALE_MAP.get(text.replace("_", "-").toLowerCase(Locale.ROOT));
        }
        if (l != null) {
            return LanguageUtils.getIso3BLanguage(l);
        }
        return "";
    }

    public static String getIso2LanguageFromLocalizedString(String text) {
        Locale l = KEY_TO_LOCALE_MAP.get(text.toLowerCase(Locale.ROOT));
        if (l == null) {
            l = KEY_TO_LOCALE_MAP.get(text.replace("_", "-").toLowerCase(Locale.ROOT));
        }
        if (l != null) {
            if ("pt-BR".equals(l.toLanguageTag())) {
                return "pb";
            }
            return l.getLanguage();
        }
        return "";
    }

    public static String getEnglishLanguageNameFromLocalizedString(String text) {
        Locale l = KEY_TO_LOCALE_MAP.get(text.toLowerCase(Locale.ROOT));
        if (l == null) {
            l = KEY_TO_LOCALE_MAP.get(text.replace("_", "-").toLowerCase(Locale.ROOT));
        }
        if (l != null) {
            return l.getDisplayLanguage(Locale.ENGLISH);
        }
        return "";
    }

    public static String getLocalizedLanguageNameFromLocalizedString(String text) {
        return LanguageUtils.getLocalizedLanguageNameFromLocalizedString(Locale.getDefault(), text);
    }

    public static String getLocalizedLanguageNameFromLocalizedString(Locale language, String ... text) {
        String ret = "";
        if (language == null) {
            language = Locale.getDefault();
        }
        for (String s : text) {
            Locale l = KEY_TO_LOCALE_MAP.get(s.toLowerCase(Locale.ROOT));
            if (l == null) {
                l = KEY_TO_LOCALE_MAP.get(s.replace("_", "-").toLowerCase(Locale.ROOT));
            }
            if (l != null && !(ret = l.getDisplayLanguage(language)).isEmpty()) break;
        }
        if (ret.isEmpty() && text.length > 0) {
            ret = text[0];
        }
        return ret;
    }

    public static String getLocalizedCountry(String ... countries) {
        return LanguageUtils.getLocalizedCountryForLanguage(Locale.getDefault().getLanguage(), countries);
    }

    public static String getLocalizedCountryForLanguage(String language, String ... countries) {
        Locale l = KEY_TO_LOCALE_MAP.get(language.toLowerCase(Locale.ROOT));
        if (l == null) {
            l = KEY_TO_LOCALE_MAP.get(language.replace("_", "-").toLowerCase(Locale.ROOT));
        }
        return LanguageUtils.getLocalizedCountryForLanguage(l, countries);
    }

    public static String getLocalizedCountryForLanguage(Locale language, String ... countries) {
        String ret = "";
        if (language == null) {
            language = Locale.getDefault();
        }
        for (String c : countries) {
            Locale l = KEY_TO_COUNTRY_LOCALE_MAP.get(c.toLowerCase(Locale.ROOT));
            if (l == null) {
                l = KEY_TO_LOCALE_MAP.get(c.replace("_", "-").toLowerCase(Locale.ROOT));
            }
            if (l != null && !(ret = l.getDisplayCountry(language)).isEmpty()) break;
        }
        if (ret.isEmpty() && countries.length > 0) {
            ret = countries[0];
        }
        return ret;
    }

    public static boolean doesStringEndWithLanguage(String string, String language) {
        String languageInLowercase;
        String stringInLowercase = string.toLowerCase(Locale.ROOT);
        if (stringInLowercase.equals(languageInLowercase = language.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (StringUtils.endsWith((CharSequence)stringInLowercase, (CharSequence)("." + languageInLowercase))) {
            return true;
        }
        if (StringUtils.endsWith((CharSequence)stringInLowercase, (CharSequence)("-" + languageInLowercase))) {
            return true;
        }
        if (StringUtils.endsWith((CharSequence)stringInLowercase, (CharSequence)("_" + languageInLowercase))) {
            return true;
        }
        return StringUtils.endsWith((CharSequence)stringInLowercase, (CharSequence)(" " + languageInLowercase));
    }

    public static String parseLanguageFromString(String string) {
        String result = LanguageUtils.findLanguageInString(string);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return LanguageUtils.getIso3LanguageFromLocalizedString(result);
        }
        return "";
    }

    public static String findLanguageInString(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        try {
            Set<String> langArray = KEY_TO_LOCALE_MAP.keySet();
            string = string.replaceAll("(?i)Part [Ii]+", "");
            string = string.toLowerCase(Locale.ROOT);
            string = StringUtils.split((String)string, (char)'/')[0].strip();
            for (String s : langArray) {
                try {
                    if (!LanguageUtils.doesStringEndWithLanguage(string, s)) continue;
                    return s;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    static {
        ISO_639_2B_EXCEPTIONS = LanguageUtils.createIso6392BExceptions();
        KEY_TO_LOCALE_MAP = LanguageUtils.generateLanguageArray();
        KEY_TO_COUNTRY_LOCALE_MAP = LanguageUtils.generateCountryArray();
        MONTH_REGIONAL_TO_NUM = LanguageUtils.generateMonthNameArray();
    }
}

