/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AesUtil;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.config.MediaProviderConfigObject;
import org.tinymediamanager.scraper.util.ListUtils;

public class MediaProviderConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaProviderConfig.class);
    private static final String SALT = "3FF2EB019C627B9652257EAAD71812269851E84295370EB132882F88C0A59A76";
    private static final String IV = "E17D2C8927726ACE1E7510A1BDD3D439";
    private static final AesUtil AES_UTIL = new AesUtil(128, 100);
    private final Map<String, MediaProviderConfigObject> settings = new LinkedHashMap<String, MediaProviderConfigObject>();
    private final String id;
    private final String subId;

    public MediaProviderConfig(MediaProviderInfo mpi) {
        this.id = mpi.getId();
        this.subId = mpi.getSubId();
    }

    public void load() {
        this.loadFromDir(Globals.DATA_FOLDER);
    }

    void loadFromDir(String folder) {
        if (this.settings.isEmpty()) {
            return;
        }
        Properties p = new Properties();
        Path conf = Paths.get(folder, "scraper_" + this.id + "_" + this.subId + ".conf");
        if (!Files.exists(conf, new LinkOption[0])) {
            conf = Paths.get(folder, "scraper_" + this.id + ".conf");
        }
        if (Files.exists(conf, new LinkOption[0])) {
            try (InputStream stream = Files.newInputStream(conf, new OpenOption[0]);){
                p.load(stream);
                LOGGER.info("Load scraper settings for '{}' from '{}'", (Object)this.id, (Object)conf);
                for (MediaProviderConfigObject co : this.settings.values()) {
                    String value = p.getProperty(co.getKey());
                    if (co.isEncrypt()) {
                        value = MediaProviderConfig.decryptField(value, co.getKey());
                    }
                    co.setValue(value == null ? co.getDefaultValue() : value);
                }
            }
            catch (Exception e) {
                LOGGER.trace("Cannot load settings '{}' - using defaults", (Object)conf);
            }
        }
    }

    public void save() {
        this.saveToDir(Globals.DATA_FOLDER);
    }

    void saveToDir(String folder) {
        if (this.settings.isEmpty()) {
            return;
        }
        Properties p = new Properties();
        for (MediaProviderConfigObject co : this.settings.values()) {
            String value = co.getValue();
            if (co.isEncrypt()) {
                value = MediaProviderConfig.encryptField(value, co.getKey());
            }
            p.setProperty(co.getKey(), value);
        }
        Path conf = this.id.equalsIgnoreCase(this.subId) ? Paths.get(folder, "scraper_" + this.id + ".conf") : Paths.get(folder, "scraper_" + this.id + "_" + this.subId + ".conf");
        try (OutputStream stream = Files.newOutputStream(conf, new OpenOption[0]);){
            p.store(stream, "");
        }
        catch (IOException e) {
            LOGGER.warn("Cannot write scraper settings for '{}/{}' : {}", new Object[]{this.id, this.subId, e.getMessage()});
        }
    }

    public boolean hasConfig() {
        return !this.settings.isEmpty();
    }

    public Map<String, MediaProviderConfigObject> getConfigObjects() {
        return this.settings;
    }

    public Map<String, String> getConfigKeyValuePairs() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, MediaProviderConfigObject> entry : this.settings.entrySet()) {
            if (entry.getValue().type == MediaProviderConfigObject.ConfigType.LABEL) continue;
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return result;
    }

    public MediaProviderConfigObject getConfigObject(String key) {
        MediaProviderConfigObject co = this.settings.get(key);
        if (co == null) {
            return MediaProviderConfigObject.EMPTY_OBJECT;
        }
        return co;
    }

    public String getValue(String key) {
        String result = this.getConfigObject(key).getValue();
        if (StringUtils.isBlank((CharSequence)result)) {
            return "";
        }
        return StringUtils.strip((String)result);
    }

    public Integer getValueIndex(String key) {
        return this.getConfigObject(key).getValueIndex();
    }

    public boolean getValueAsBool(String key) {
        return this.getConfigObject(key).getValueAsBool();
    }

    public boolean getValueAsBool(String key, boolean defaultValue) {
        if (this.settings.get(key) == null) {
            return defaultValue;
        }
        return this.getConfigObject(key).getValueAsBool();
    }

    public Integer getValueAsInteger(String key) {
        return this.getConfigObject(key).getValueAsInteger();
    }

    public void setValue(String key, String value) {
        MediaProviderConfigObject co = this.getConfigObject(key);
        if (co == MediaProviderConfigObject.EMPTY_OBJECT) {
            return;
        }
        co.setValue(value);
    }

    public void setValue(String key, boolean value) {
        MediaProviderConfigObject co = this.getConfigObject(key);
        if (co == MediaProviderConfigObject.EMPTY_OBJECT) {
            return;
        }
        co.setValue(value);
    }

    public void setValue(String key, Integer value) {
        MediaProviderConfigObject co = this.getConfigObject(key);
        if (co == MediaProviderConfigObject.EMPTY_OBJECT) {
            return;
        }
        co.setValue(value);
    }

    public void addLabel(String key, String keyDescription) {
        MediaProviderConfigObject co = new MediaProviderConfigObject(key, MediaProviderConfigObject.ConfigType.LABEL);
        co.setKeyDescription(keyDescription);
        this.settings.put(key, co);
    }

    public void addBoolean(String key, boolean defaultValue) {
        this.addBoolean(key, "", defaultValue);
    }

    public void addBoolean(String key, String keyDescription, boolean defaultValue) {
        MediaProviderConfigObject co = new MediaProviderConfigObject(key, MediaProviderConfigObject.ConfigType.BOOL);
        co.setKeyDescription(keyDescription);
        co.setDefaultValue(String.valueOf(defaultValue));
        co.setValue(String.valueOf(defaultValue));
        this.settings.put(key, co);
    }

    public void addText(String key, String defaultValue) {
        this.addText(key, defaultValue, false);
    }

    public void addText(String key, String keyDescription, String defaultValue) {
        this.addText(key, keyDescription, defaultValue, false);
    }

    public void addText(String key, String defaultValue, boolean encrypt) {
        this.addText(key, "", defaultValue, encrypt);
    }

    public void addText(String key, String keyDescription, String defaultValue, boolean encrypt) {
        MediaProviderConfigObject co = new MediaProviderConfigObject(key, MediaProviderConfigObject.ConfigType.TEXT);
        co.setKeyDescription(keyDescription);
        co.setDefaultValue(defaultValue);
        co.setValue(defaultValue);
        co.setEncrypt(encrypt);
        this.settings.put(key, co);
    }

    public void addInteger(String key, Integer defaultValue) {
        this.addInteger(key, "", defaultValue);
    }

    public void addInteger(String key, String keyDescription, Integer defaultValue) {
        MediaProviderConfigObject co = new MediaProviderConfigObject(key, MediaProviderConfigObject.ConfigType.INTEGER);
        co.setKeyDescription(keyDescription);
        co.setDefaultValue(defaultValue.toString());
        co.setValue(defaultValue);
        this.settings.put(key, co);
    }

    public void addSelect(String key, String[] possibleValues, String defaultValue) {
        this.addSelect(key, "", possibleValues, defaultValue);
    }

    public void addSelect(String key, String keyDescription, String[] possibleValues, String defaultValue) {
        this.addSelect(key, keyDescription, Arrays.asList(possibleValues), defaultValue);
    }

    public void addSelect(String key, Set<String> possibleValues, String defaultValue) {
        this.addSelect(key, "", possibleValues.toArray(new String[0]), defaultValue);
    }

    public void addSelect(String key, List<String> possibleValues, String defaultValue) {
        this.addSelect(key, "", possibleValues, defaultValue);
    }

    public void addSelect(String key, String keyDescription, Enum<?>[] possibleValues, Enum<?> defaultValue) {
        ArrayList<String> values = new ArrayList<String>();
        for (Enum<?> e : possibleValues) {
            values.add(e.name());
        }
        this.addSelect(key, keyDescription, values, defaultValue.name());
    }

    public void addSelect(String key, Enum<?>[] possibleValues, Enum<?> defaultValue) {
        this.addSelect(key, "", possibleValues, defaultValue);
    }

    public void addSelect(String key, String keyDescription, List<String> possibleValues, String defaultValue) {
        MediaProviderConfigObject co = new MediaProviderConfigObject(key, MediaProviderConfigObject.ConfigType.SELECT);
        co.setKeyDescription(keyDescription);
        for (String s : ListUtils.nullSafe(possibleValues)) {
            co.addPossibleValue(s);
        }
        co.setDefaultValue(defaultValue);
        co.setValue(defaultValue);
        this.settings.put(key, co);
    }

    public void addSelectIndex(String key, String[] possibleValues, String defaultValue) {
        this.addSelectIndex(key, "", possibleValues, defaultValue);
    }

    public void addSelectIndex(String key, String keyDescription, String[] possibleValues, String defaultValue) {
        this.addSelectIndex(key, keyDescription, Arrays.asList(possibleValues), defaultValue);
    }

    public void addSelectIndex(String key, List<String> possibleValues, String defaultValue) {
        this.addSelectIndex(key, "", possibleValues, defaultValue);
    }

    public void addSelectIndex(String key, String keyDescription, List<String> possibleValues, String defaultValue) {
        MediaProviderConfigObject co = new MediaProviderConfigObject(key, MediaProviderConfigObject.ConfigType.SELECT_INDEX);
        co.setKeyDescription(keyDescription);
        for (String s : possibleValues) {
            co.addPossibleValue(s);
        }
        co.setDefaultValue(defaultValue);
        co.setValue(defaultValue);
        this.settings.put(key, co);
    }

    public void addMultiSelect(String key, String keyDescription, List<String> possibleValues, String ... defaultValues) {
        MediaProviderConfigObject co = new MediaProviderConfigObject(key, MediaProviderConfigObject.ConfigType.MULTI_SELECT);
        co.setKeyDescription(keyDescription);
        for (String s : possibleValues) {
            co.addPossibleValue(s);
        }
        if (defaultValues != null) {
            co.setDefaultValue(Arrays.toString(defaultValues));
            co.setValue(Arrays.toString(defaultValues));
        }
        this.settings.put(key, co);
    }

    private static String encryptField(String value, String key) {
        return AES_UTIL.encrypt(SALT, IV, key, value);
    }

    private static String decryptField(String value, String key) {
        return AES_UTIL.decrypt(SALT, IV, key, value);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

