/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.ITvShowSeasonFileNaming;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.tasks.TvShowExtraImageFetcherTask;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.thirdparty.VSMeta;

public class TvShowArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowArtworkHelper.class);
    private static final Pattern INDEX_PATTERN = Pattern.compile(".*?(\\d+)$");

    private TvShowArtworkHelper() {
        throw new IllegalAccessError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadArtwork(TvShow show, MediaFileType type) {
        if (type == MediaFileType.EXTRAFANART) {
            TvShowArtworkHelper.downloadExtraArtwork(show, type);
            return;
        }
        String url = show.getArtworkUrl(type);
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                return;
            }
            ArrayList<Enum> fileNamings = new ArrayList<Enum>();
            switch (type) {
                case FANART: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getFanartFilenames());
                    break;
                }
                case POSTER: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getPosterFilenames());
                    break;
                }
                case BANNER: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getBannerFilenames());
                    break;
                }
                case CLEARLOGO: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getClearlogoFilenames());
                    break;
                }
                case CHARACTERART: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getCharacterartFilenames());
                    break;
                }
                case CLEARART: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getClearartFilenames());
                    break;
                }
                case THUMB: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getThumbFilenames());
                    break;
                }
                case KEYART: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getKeyartFilenames());
                    break;
                }
                default: {
                    return;
                }
            }
            ArrayList<String> filenames = new ArrayList<String>();
            for (IFileNaming iFileNaming : fileNamings) {
                String filename = iFileNaming.getFilename(show.getFoldername(), Utils.getArtworkExtensionFromUrl(url));
                if (StringUtils.isBlank((CharSequence)filename)) continue;
                filenames.add(filename);
            }
            if (!filenames.isEmpty()) {
                MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(show, url, MediaFileType.getMediaArtworkType(type), filenames);
                TmmTaskManager.getInstance().addImageDownloadTask(task);
            }
        }
        finally {
            if (url.startsWith("file:")) {
                show.removeArtworkUrl(type);
            }
        }
    }

    public static void downloadMissingArtwork(TvShow tvShow, List<MediaArtwork> artwork) {
        if (!TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.POSTER)) {
            TvShowArtworkHelper.setBestPoster(tvShow, artwork, false);
        }
        if (!TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.FANART)) {
            TvShowArtworkHelper.setBestFanart(tvShow, artwork, false);
        }
        if (!TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.CLEARLOGO)) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, false);
        }
        if (!TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.CLEARART)) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARART, false);
        }
        if (!TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.BANNER)) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.BANNER, false);
        }
        if (!TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.THUMB)) {
            TvShowArtworkHelper.setBestThumb(tvShow, artwork, false);
        }
        if (!TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.DISC)) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.DISC, false);
        }
        if (!TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.CHARACTERART)) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CHARACTERART, false);
        }
        if (!TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.KEYART)) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.KEYART, false);
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            TvShowArtworkHelper.downloadMissingArtwork(season, artwork);
        }
        tvShow.saveToDb();
        if (TvShowModuleManager.getInstance().getSettings().isNfoWriteArtworkUrls()) {
            tvShow.writeNFO();
        }
    }

    public static void downloadMissingArtwork(TvShowSeason season, List<MediaArtwork> artwork) {
        List<MediaArtwork.ImageSizeAndUrl> sortedThumbs;
        List<MediaArtwork.ImageSizeAndUrl> sortedArtwork;
        List<MediaArtwork.ImageSizeAndUrl> sortedFanarts;
        int preferredSizeOrder;
        List<MediaArtwork.ImageSizeAndUrl> sortedPosters;
        List<MediaArtwork> seasonArtwork = artwork.stream().filter(mediaArtwork -> mediaArtwork.getSeason() == season.getSeason()).toList();
        if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_POSTER)) && !(sortedPosters = TvShowArtworkHelper.sortArtworkUrls(seasonArtwork, MediaArtwork.MediaArtworkType.SEASON_POSTER, preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImagePosterSize().getOrder())).isEmpty()) {
            season.setArtworkUrl(sortedPosters.get(0).getUrl(), MediaFileType.SEASON_POSTER);
            TvShowArtworkHelper.downloadSeasonArtwork(season, TvShowModuleManager.getInstance().getSettings().getSeasonPosterFilenames(), MediaFileType.SEASON_POSTER);
        }
        if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_FANART)) && !(sortedFanarts = TvShowArtworkHelper.sortArtworkUrls(seasonArtwork, MediaArtwork.MediaArtworkType.SEASON_FANART, preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImageFanartSize().getOrder())).isEmpty()) {
            season.setArtworkUrl(sortedFanarts.get(0).getUrl(), MediaFileType.SEASON_FANART);
            TvShowArtworkHelper.downloadSeasonArtwork(season, TvShowModuleManager.getInstance().getSettings().getSeasonFanartFilenames(), MediaFileType.SEASON_FANART);
        }
        if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_BANNER)) && !(sortedArtwork = TvShowArtworkHelper.sortArtworkUrls(seasonArtwork, MediaArtwork.MediaArtworkType.SEASON_BANNER, preferredSizeOrder = 32)).isEmpty()) {
            season.setArtworkUrl(sortedArtwork.get(0).getUrl(), MediaFileType.SEASON_BANNER);
            TvShowArtworkHelper.downloadSeasonArtwork(season, TvShowModuleManager.getInstance().getSettings().getSeasonBannerFilenames(), MediaFileType.SEASON_BANNER);
        }
        if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_THUMB)) && !(sortedThumbs = TvShowArtworkHelper.sortArtworkUrls(seasonArtwork, MediaArtwork.MediaArtworkType.SEASON_THUMB, preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImageThumbSize().getOrder())).isEmpty()) {
            season.setArtworkUrl(sortedThumbs.get(0).getUrl(), MediaFileType.SEASON_THUMB);
            TvShowArtworkHelper.downloadSeasonArtwork(season, TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames(), MediaFileType.SEASON_THUMB);
        }
    }

    private static boolean hasArtwork(TvShow tvShow, MediaFileType type) {
        for (MediaFile artwork : tvShow.getMediaFiles(type)) {
            if (artwork.getFilesize() <= 0L) continue;
            return true;
        }
        return false;
    }

    public static List<MediaFile> getArtworkFiles(TvShow tvShow, MediaFileType type) {
        ArrayList<MediaFile> artworkFiles = new ArrayList<MediaFile>();
        for (MediaFile artwork : tvShow.getMediaFiles(type)) {
            if (artwork.getFilesize() <= 0L) continue;
            artworkFiles.add(artwork);
        }
        return artworkFiles;
    }

    public static List<MediaFile> getArtworkFiles(TvShowEpisode episode, MediaFileType type) {
        ArrayList<MediaFile> artworkFiles = new ArrayList<MediaFile>();
        for (MediaFile artwork : episode.getMediaFiles(type)) {
            if (artwork.getFilesize() <= 0L) continue;
            artworkFiles.add(artwork);
        }
        return artworkFiles;
    }

    private static void setBestPoster(TvShow tvShow, List<MediaArtwork> artwork, boolean overwrite) {
        boolean posterFound = false;
        if (!overwrite && StringUtils.isNotBlank((CharSequence)tvShow.getArtworkUrl(MediaFileType.POSTER))) {
            posterFound = true;
        } else {
            int preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
            List<MediaArtwork.ImageSizeAndUrl> sortedPosters = TvShowArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.POSTER, preferredSizeOrder);
            if (!sortedPosters.isEmpty()) {
                MediaArtwork.ImageSizeAndUrl foundPoster = sortedPosters.get(0);
                tvShow.setArtworkUrl(foundPoster.getUrl(), MediaFileType.POSTER);
                posterFound = true;
            }
        }
        if (posterFound && !TvShowModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.POSTER);
        }
    }

    public static List<MediaArtwork.ImageSizeAndUrl> sortArtworkUrls(List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, int sizeOrder) {
        ArrayList<MediaArtwork> artworkForType = new ArrayList<MediaArtwork>(artwork.stream().filter(art -> !"ffmpeg".equalsIgnoreCase(art.getProviderId()) && art.getType() == type).sorted((o1, o2) -> o2.getLikes() - o1.getLikes()).toList());
        ArrayList<MediaArtwork> artworkFromFfmpeg = new ArrayList<MediaArtwork>(artwork.stream().filter(art -> "ffmpeg".equalsIgnoreCase(art.getProviderId()) && art.getType() == type).sorted((o1, o2) -> o2.getLikes() - o1.getLikes()).toList());
        MediaArtwork ffmpegArtwork = ListUtils.getMiddle(artworkFromFfmpeg);
        if (artworkForType.isEmpty() && ffmpegArtwork == null) {
            return Collections.emptyList();
        }
        ArrayList<MediaArtwork.ImageSizeAndUrl> sortedArtwork = new ArrayList<MediaArtwork.ImageSizeAndUrl>();
        if (sizeOrder == 0) {
            artworkForType.sort((o1, o2) -> {
                int result = Integer.compare(o2.getBiggestArtwork().getWidth(), o1.getBiggestArtwork().getWidth());
                if (result == 0) {
                    result = o2.getLikes() - o1.getLikes();
                }
                return result;
            });
        }
        List<MediaLanguages> languages = TvShowModuleManager.getInstance().getSettings().getImageScraperLanguages();
        for (MediaLanguages language : languages) {
            for (MediaArtwork art2 : artworkForType.stream().filter(art -> art.getLanguage().equals(language.getLanguage())).toList()) {
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art2.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != sizeOrder || sortedArtwork.contains(imageSizeAndUrl)) continue;
                    sortedArtwork.add(imageSizeAndUrl);
                }
            }
        }
        if (sortedArtwork.isEmpty() && ffmpegArtwork != null) {
            for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : ffmpegArtwork.getImageSizes()) {
                if (imageSizeAndUrl.getSizeOrder() != sizeOrder || sortedArtwork.contains(imageSizeAndUrl)) continue;
                sortedArtwork.add(imageSizeAndUrl);
            }
        }
        List<Integer> sizeOrders = MediaArtwork.sortSizeOrderByPreference(sizeOrder);
        if (sortedArtwork.isEmpty() && TvShowModuleManager.getInstance().getSettings().isImageScraperOtherResolutions()) {
            for (Integer newOrder : sizeOrders) {
                for (MediaLanguages language : languages) {
                    for (MediaArtwork art3 : artworkForType.stream().filter(art -> art.getLanguage().equals(language.getLanguage())).toList()) {
                        for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art3.getImageSizes()) {
                            if (imageSizeAndUrl.getSizeOrder() != newOrder.intValue() || sortedArtwork.contains(imageSizeAndUrl)) continue;
                            sortedArtwork.add(imageSizeAndUrl);
                        }
                    }
                }
            }
        }
        if (sortedArtwork.isEmpty() && TvShowModuleManager.getInstance().getSettings().isImageScraperOtherResolutions() && ffmpegArtwork != null) {
            for (Integer newOrder : sizeOrders) {
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : ffmpegArtwork.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != newOrder.intValue() || sortedArtwork.contains(imageSizeAndUrl)) continue;
                    sortedArtwork.add(imageSizeAndUrl);
                }
            }
        }
        if (sortedArtwork.isEmpty() && ffmpegArtwork != null) {
            sortedArtwork.addAll(ffmpegArtwork.getImageSizes());
        }
        if (TvShowModuleManager.getInstance().getSettings().isImageScraperFallback()) {
            for (Integer newOrder : sizeOrders) {
                for (MediaArtwork art4 : artworkForType) {
                    for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art4.getImageSizes()) {
                        if (imageSizeAndUrl.getSizeOrder() != newOrder.intValue() || sortedArtwork.contains(imageSizeAndUrl)) continue;
                        sortedArtwork.add(imageSizeAndUrl);
                    }
                }
            }
        }
        return sortedArtwork;
    }

    public static int getMatchingScoreAccordingPreferences(MediaArtwork ma) {
        List<MediaLanguages> languages = TvShowModuleManager.getInstance().getSettings().getImageScraperLanguages();
        int size = 0;
        switch (ma.getType()) {
            case POSTER: 
            case KEYART: 
            case SEASON_POSTER: {
                size = TvShowModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
                break;
            }
            case THUMB: 
            case SEASON_THUMB: {
                size = TvShowModuleManager.getInstance().getSettings().getImageThumbSize().getOrder();
                break;
            }
            default: {
                size = TvShowModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
            }
        }
        boolean preferFanartWoText = TvShowModuleManager.getInstance().getSettings().isImageScraperPreferFanartWoText();
        int score = ma.getMatchingScoreAccordingPreferences(size, languages, preferFanartWoText);
        return score;
    }

    private static void setBestArtwork(TvShow tvShow, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, boolean overwrite) {
        boolean artworkFound = false;
        if (!overwrite && StringUtils.isNotBlank((CharSequence)tvShow.getArtworkUrl(MediaFileType.getMediaFileType(type)))) {
            artworkFound = true;
        } else {
            int preferredSizeOrder = 32;
            List<MediaArtwork.ImageSizeAndUrl> sortedArtwork = TvShowArtworkHelper.sortArtworkUrls(artwork, type, preferredSizeOrder);
            if (!sortedArtwork.isEmpty()) {
                MediaArtwork.ImageSizeAndUrl bestArtwork = sortedArtwork.get(0);
                tvShow.setArtworkUrl(bestArtwork.getUrl(), MediaFileType.getMediaFileType(type));
                artworkFound = true;
            }
        }
        if (artworkFound) {
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.getMediaFileType(type));
        }
    }

    private static void setBestFanart(TvShow tvShow, List<MediaArtwork> artwork, boolean overwrite) {
        boolean fanartFound = false;
        if (!overwrite && StringUtils.isNotBlank((CharSequence)tvShow.getArtworkUrl(MediaFileType.FANART))) {
            fanartFound = true;
        } else {
            int preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
            MediaArtwork.ImageSizeAndUrl fanartWoText = null;
            block0: for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals("")) continue;
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != preferredSizeOrder) continue;
                    fanartWoText = imageSizeAndUrl;
                    continue block0;
                }
            }
            List<MediaArtwork.ImageSizeAndUrl> sortedFanarts = TvShowArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, preferredSizeOrder);
            if (fanartWoText != null) {
                sortedFanarts.add(0, fanartWoText);
            }
            if (!sortedFanarts.isEmpty()) {
                MediaArtwork.ImageSizeAndUrl foundfanart = sortedFanarts.get(0);
                tvShow.setArtworkUrl(foundfanart.getUrl(), MediaFileType.FANART);
                fanartFound = true;
            }
        }
        if (fanartFound && !TvShowModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.FANART);
        }
    }

    private static void setBestThumb(TvShow tvShow, List<MediaArtwork> artwork, boolean overwrite) {
        boolean thumbFound = false;
        if (!overwrite && StringUtils.isNotBlank((CharSequence)tvShow.getArtworkUrl(MediaFileType.THUMB))) {
            thumbFound = true;
        } else {
            int preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImageThumbSize().getOrder();
            List<MediaArtwork.ImageSizeAndUrl> sortedPosters = TvShowArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.THUMB, preferredSizeOrder);
            if (!sortedPosters.isEmpty()) {
                MediaArtwork.ImageSizeAndUrl foundThumb = sortedPosters.get(0);
                tvShow.setArtworkUrl(foundThumb.getUrl(), MediaFileType.THUMB);
                thumbFound = true;
            }
        }
        if (thumbFound && !TvShowModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty()) {
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.THUMB);
        }
    }

    public static boolean hasMissingArtwork(TvShow tvShow, List<TvShowScraperMetadataConfig> config) {
        if (config.contains(TvShowScraperMetadataConfig.POSTER) && !TvShowModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.POSTER)) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.FANART) && !TvShowModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.FANART)) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.BANNER) && !TvShowModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.BANNER)) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.DISCART) && !TvShowModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.DISC)) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.CLEARLOGO) && !TvShowModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.CLEARLOGO)) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.CLEARART) && !TvShowModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.CLEARART)) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.THUMB) && !TvShowModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.THUMB)) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.CHARACTERART) && !TvShowModuleManager.getInstance().getSettings().getCharacterartFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.CHARACTERART)) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.KEYART) && !TvShowModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.KEYART)) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.EXTRAFANART) && TvShowModuleManager.getInstance().getSettings().isImageExtraFanart() && !TvShowModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty() && !TvShowArtworkHelper.hasArtwork(tvShow, MediaFileType.EXTRAFANART)) {
            return true;
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            if (!TvShowArtworkHelper.hasMissingArtwork(season, config)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMissingArtwork(TvShowSeason season, List<TvShowScraperMetadataConfig> config) {
        if (config.contains(TvShowScraperMetadataConfig.SEASON_POSTER) && !TvShowModuleManager.getInstance().getSettings().getSeasonPosterFilenames().isEmpty() && StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_POSTER))) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_FANART) && !TvShowModuleManager.getInstance().getSettings().getSeasonFanartFilenames().isEmpty() && StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_FANART))) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_BANNER) && !TvShowModuleManager.getInstance().getSettings().getSeasonBannerFilenames().isEmpty() && StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_BANNER))) {
            return true;
        }
        return config.contains(TvShowScraperMetadataConfig.SEASON_THUMB) && !TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames().isEmpty() && StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_THUMB));
    }

    public static boolean hasMissingArtwork(TvShowEpisode episode, List<TvShowEpisodeScraperMetadataConfig> config) {
        return config.contains(TvShowEpisodeScraperMetadataConfig.THUMB) && !TvShowModuleManager.getInstance().getSettings().getEpisodeThumbFilenames().isEmpty() && episode.getMediaFiles(MediaFileType.THUMB).isEmpty();
    }

    public static void downloadSeasonArtwork(TvShowSeason tvShowSeason, MediaFileType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                TvShowArtworkHelper.downloadSeasonArtwork(tvShowSeason, TvShowModuleManager.getInstance().getSettings().getSeasonPosterFilenames(), artworkType);
                break;
            }
            case SEASON_FANART: {
                TvShowArtworkHelper.downloadSeasonArtwork(tvShowSeason, TvShowModuleManager.getInstance().getSettings().getSeasonFanartFilenames(), artworkType);
                break;
            }
            case SEASON_BANNER: {
                TvShowArtworkHelper.downloadSeasonArtwork(tvShowSeason, TvShowModuleManager.getInstance().getSettings().getSeasonBannerFilenames(), artworkType);
                break;
            }
            case SEASON_THUMB: {
                TvShowArtworkHelper.downloadSeasonArtwork(tvShowSeason, TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames(), artworkType);
            }
        }
    }

    private static void downloadSeasonArtwork(TvShowSeason tvShowSeason, List<? extends ITvShowSeasonFileNaming> fileNamings, MediaFileType mediaFileType) {
        if (!tvShowSeason.getEpisodes().isEmpty() || TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems()) {
            String seasonArtworkUrl = tvShowSeason.getArtworkUrl(mediaFileType);
            for (ITvShowSeasonFileNaming iTvShowSeasonFileNaming : fileNamings) {
                String filename = iTvShowSeasonFileNaming.getFilename(tvShowSeason, Utils.getArtworkExtensionFromUrl(seasonArtworkUrl), false);
                if (StringUtils.isBlank((CharSequence)filename)) {
                    LOGGER.warn("Empty filename for season artwork: '{}' - '{}'", (Object)iTvShowSeasonFileNaming.name(), (Object)tvShowSeason);
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, tvShowSeason, "tvshow.seasondownload.failed"));
                    continue;
                }
                Path destFile = tvShowSeason.getTvShow().getPathNIO().resolve(filename);
                if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                    try {
                        Files.createDirectory(destFile.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not create folder '{}' - '{}'", (Object)destFile.getParent(), (Object)e.getMessage());
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, tvShowSeason, "tvshow.seasondownload.failed"));
                        continue;
                    }
                }
                SeasonArtworkImageFetcher task = new SeasonArtworkImageFetcher(tvShowSeason, destFile, seasonArtworkUrl, mediaFileType);
                TmmTaskManager.getInstance().addImageDownloadTask(task);
            }
            if (seasonArtworkUrl.startsWith("file:")) {
                tvShowSeason.removeArtworkUrl(mediaFileType);
            }
        }
    }

    public static void setArtwork(TvShow tvShow, List<MediaArtwork> artwork, List<TvShowScraperMetadataConfig> config, boolean overwrite) {
        List<MediaArtwork> seasonArtwork;
        int preferredSizeOrder;
        if (!ScraperMetadataConfig.containsAnyArtwork(config)) {
            return;
        }
        if (config.contains(TvShowScraperMetadataConfig.POSTER) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.POSTER)))) {
            TvShowArtworkHelper.setBestPoster(tvShow, artwork, overwrite);
        }
        if (config.contains(TvShowScraperMetadataConfig.FANART) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.FANART)))) {
            TvShowArtworkHelper.setBestFanart(tvShow, artwork, overwrite);
        }
        if (config.contains(TvShowScraperMetadataConfig.BANNER) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.BANNER)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.BANNER, overwrite);
        }
        if (config.contains(TvShowScraperMetadataConfig.CLEARLOGO) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.CLEARLOGO)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, overwrite);
        }
        if (config.contains(TvShowScraperMetadataConfig.CLEARART) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.CLEARART)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARART, overwrite);
        }
        if (config.contains(TvShowScraperMetadataConfig.THUMB) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.THUMB)))) {
            TvShowArtworkHelper.setBestThumb(tvShow, artwork, overwrite);
        }
        if (config.contains(TvShowScraperMetadataConfig.CHARACTERART)) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CHARACTERART, overwrite);
        }
        if (config.contains(TvShowScraperMetadataConfig.KEYART) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.KEYART)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.KEYART, overwrite);
        }
        boolean seasonArtworkWritten = false;
        if (config.contains(TvShowScraperMetadataConfig.SEASON_POSTER)) {
            preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
            for (TvShowSeason season : tvShow.getSeasons()) {
                List<MediaArtwork.ImageSizeAndUrl> sortedPosters;
                if (!overwrite && !StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_POSTER)) || (sortedPosters = TvShowArtworkHelper.sortArtworkUrls(seasonArtwork = artwork.stream().filter(mediaArtwork -> mediaArtwork.getSeason() == season.getSeason()).toList(), MediaArtwork.MediaArtworkType.SEASON_POSTER, preferredSizeOrder)).isEmpty()) continue;
                season.setArtworkUrl(sortedPosters.get(0).getUrl(), MediaFileType.SEASON_POSTER);
                TvShowArtworkHelper.downloadSeasonArtwork(season, TvShowModuleManager.getInstance().getSettings().getSeasonPosterFilenames(), MediaFileType.SEASON_POSTER);
                seasonArtworkWritten = true;
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_FANART)) {
            preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
            for (TvShowSeason season : tvShow.getSeasons()) {
                List<MediaArtwork.ImageSizeAndUrl> sortedFanarts;
                if (!overwrite && !StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_FANART)) || (sortedFanarts = TvShowArtworkHelper.sortArtworkUrls(seasonArtwork = artwork.stream().filter(mediaArtwork -> mediaArtwork.getSeason() == season.getSeason()).toList(), MediaArtwork.MediaArtworkType.SEASON_FANART, preferredSizeOrder)).isEmpty()) continue;
                season.setArtworkUrl(sortedFanarts.get(0).getUrl(), MediaFileType.SEASON_FANART);
                TvShowArtworkHelper.downloadSeasonArtwork(season, TvShowModuleManager.getInstance().getSettings().getSeasonFanartFilenames(), MediaFileType.SEASON_FANART);
                seasonArtworkWritten = true;
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_BANNER)) {
            preferredSizeOrder = 32;
            for (TvShowSeason season : tvShow.getSeasons()) {
                List<MediaArtwork.ImageSizeAndUrl> sortedArtwork;
                if (!overwrite && !StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_BANNER)) || (sortedArtwork = TvShowArtworkHelper.sortArtworkUrls(seasonArtwork = artwork.stream().filter(mediaArtwork -> mediaArtwork.getSeason() == season.getSeason()).toList(), MediaArtwork.MediaArtworkType.SEASON_BANNER, preferredSizeOrder)).isEmpty()) continue;
                season.setArtworkUrl(sortedArtwork.get(0).getUrl(), MediaFileType.SEASON_BANNER);
                TvShowArtworkHelper.downloadSeasonArtwork(season, TvShowModuleManager.getInstance().getSettings().getSeasonBannerFilenames(), MediaFileType.SEASON_BANNER);
                seasonArtworkWritten = true;
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_THUMB)) {
            preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImageThumbSize().getOrder();
            for (TvShowSeason season : tvShow.getSeasons()) {
                List<MediaArtwork.ImageSizeAndUrl> sortedThumbs;
                if (!overwrite && !StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaFileType.SEASON_THUMB)) || (sortedThumbs = TvShowArtworkHelper.sortArtworkUrls(seasonArtwork = artwork.stream().filter(mediaArtwork -> mediaArtwork.getSeason() == season.getSeason()).toList(), MediaArtwork.MediaArtworkType.SEASON_THUMB, preferredSizeOrder)).isEmpty()) continue;
                season.setArtworkUrl(sortedThumbs.get(0).getUrl(), MediaFileType.SEASON_THUMB);
                TvShowArtworkHelper.downloadSeasonArtwork(season, MediaFileType.SEASON_THUMB);
                seasonArtworkWritten = true;
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.EXTRAFANART) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.EXTRAFANART)))) {
            ArrayList<String> extrafanarts = new ArrayList<String>();
            if (TvShowModuleManager.getInstance().getSettings().isImageExtraFanart() && TvShowModuleManager.getInstance().getSettings().getImageExtraFanartCount() > 0) {
                int preferredSizeOrder2 = TvShowModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
                List<MediaArtwork.ImageSizeAndUrl> sortedFanarts = TvShowArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, preferredSizeOrder2);
                for (MediaArtwork.ImageSizeAndUrl art : sortedFanarts) {
                    extrafanarts.add(art.getUrl());
                    if (extrafanarts.size() < TvShowModuleManager.getInstance().getSettings().getImageExtraFanartCount()) continue;
                    break;
                }
                tvShow.setExtraFanartUrls(extrafanarts);
                if (!extrafanarts.isEmpty()) {
                    TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.EXTRAFANART);
                }
            }
        }
        tvShow.saveToDb();
        if (seasonArtworkWritten) {
            tvShow.getSeasons().forEach(TvShowSeason::writeNfo);
        }
        if (TvShowModuleManager.getInstance().getSettings().isNfoWriteArtworkUrls()) {
            tvShow.writeNFO();
        }
    }

    private static void downloadExtraArtwork(TvShow tvShow, MediaFileType type) {
        TvShowExtraImageFetcherTask task = new TvShowExtraImageFetcherTask(tvShow, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static boolean extractArtworkFromVsmeta(TvShow tvShow, MediaFile vsMetaFile, MediaArtwork.MediaArtworkType artworkType) {
        return TvShowArtworkHelper.extractArtworkFromVsmetaInternal(tvShow, vsMetaFile, artworkType);
    }

    public static boolean extractArtworkFromVsmeta(TvShowEpisode tvShowEpisode, MediaFile vsMetaFile, MediaArtwork.MediaArtworkType artworkType) {
        return TvShowArtworkHelper.extractArtworkFromVsmetaInternal(tvShowEpisode, vsMetaFile, artworkType);
    }

    private static boolean extractArtworkFromVsmetaInternal(MediaEntity mediaEntity, MediaFile vsMetaFile, MediaArtwork.MediaArtworkType artworkType) {
        byte[] bytes;
        List<Enum> fileNamings;
        block11: {
            VSMeta vsmeta;
            block10: {
                vsmeta = new VSMeta(vsMetaFile.getFileAsPath());
                if (!(mediaEntity instanceof TvShow)) break block10;
                switch (artworkType) {
                    case POSTER: {
                        fileNamings = TvShowModuleManager.getInstance().getSettings().getPosterFilenames();
                        bytes = vsmeta.getShowImageBytes();
                        break block11;
                    }
                    case BACKGROUND: {
                        fileNamings = TvShowModuleManager.getInstance().getSettings().getFanartFilenames();
                        bytes = vsmeta.getBackdropBytes();
                        break block11;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (mediaEntity instanceof TvShowEpisode && artworkType == MediaArtwork.MediaArtworkType.THUMB) {
                fileNamings = TvShowModuleManager.getInstance().getSettings().getEpisodeThumbFilenames();
                bytes = vsmeta.getPosterBytes();
            } else {
                return false;
            }
        }
        if (fileNamings.isEmpty() || bytes.length == 0) {
            return false;
        }
        String basename = FilenameUtils.getBaseName((String)FilenameUtils.getBaseName((String)vsMetaFile.getFilename()));
        for (IFileNaming iFileNaming : fileNamings) {
            try {
                String filename = iFileNaming.getFilename(basename, "jpg");
                MediaFile mf = new MediaFile(vsMetaFile.getFileAsPath().getParent().resolve(filename), MediaFileType.getMediaFileType(artworkType));
                Files.write(mf.getFileAsPath(), bytes, new OpenOption[0]);
                mediaEntity.addToMediaFiles(mf);
            }
            catch (Exception e) {
                LOGGER.warn("Could not extract VSMETA artwork from '{}' - '{}'", (Object)vsMetaFile, (Object)e.getMessage());
            }
        }
        return true;
    }

    public static int getIndexOfArtwork(String filename) {
        String basename = FilenameUtils.getBaseName((String)filename);
        Matcher matcher = INDEX_PATTERN.matcher(basename);
        if (matcher.find() && matcher.groupCount() == 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (Exception e) {
                LOGGER.debug("could not parse index of '{}'- {}", (Object)filename, (Object)e.getMessage());
            }
        }
        return -1;
    }

    private static class SeasonArtworkImageFetcher
    implements Runnable {
        private final TvShowSeason tvShowSeason;
        private final MediaFileType mediaFileType;
        private final Path destinationPath;
        private final String filename;
        private final String url;

        SeasonArtworkImageFetcher(TvShowSeason tvShowSeason, Path destFile, String url, MediaFileType mediaFileType) {
            this.tvShowSeason = tvShowSeason;
            this.destinationPath = destFile.getParent();
            this.filename = destFile.getFileName().toString();
            this.mediaFileType = mediaFileType;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String oldFilename = this.tvShowSeason.getArtworkFilename(this.mediaFileType);
            Path oldFile = Paths.get(oldFilename, new String[0]);
            LOGGER.debug("writing season artwork {}", (Object)this.filename);
            try {
                Path destFile = ImageUtils.downloadImage(this.url, this.destinationPath, this.filename);
                if (StringUtils.isNotBlank((CharSequence)oldFilename) && !oldFile.equals(destFile)) {
                    ImageCache.invalidateCachedImage(oldFile);
                    Utils.deleteFileSafely(oldFile);
                }
                this.tvShowSeason.setArtwork(destFile, this.mediaFileType);
                ImageCache.invalidateCachedImage(destFile);
                ImageCache.cacheImageSilently(destFile);
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Could not fetch image '{}' - '{}'", (Object)this.url, (Object)e.getMessage());
                if (!oldFilename.isEmpty()) {
                    this.tvShowSeason.setArtwork(oldFile, this.mediaFileType);
                }
                ImageCache.invalidateCachedImage(oldFile);
                ImageCache.cacheImageSilently(oldFile);
            }
            finally {
                this.tvShowSeason.getTvShow().saveToDb();
            }
        }
    }
}

