/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.InterruptedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.ListUtils;

public class MediaEntityImageFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntityImageFetcherTask.class);
    private final MediaEntity entity;
    private final String url;
    private final MediaArtwork.MediaArtworkType type;
    private final List<String> filenames = new ArrayList<String>();

    public MediaEntityImageFetcherTask(MediaEntity entity, String url, MediaArtwork.MediaArtworkType type, List<String> filenames) {
        this.entity = entity;
        this.url = url;
        this.type = type;
        if (ListUtils.isNotEmpty(filenames)) {
            this.filenames.addAll(filenames);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        if (this.filenames.isEmpty()) {
            return;
        }
        switch (this.type) {
            case POSTER: 
            case BACKGROUND: 
            case BANNER: 
            case THUMB: 
            case CLEARART: 
            case DISC: 
            case LOGO: 
            case CLEARLOGO: 
            case CHARACTERART: 
            case KEYART: {
                break;
            }
            default: {
                return;
            }
        }
        List<MediaFile> oldMediaFiles = this.entity.getMediaFiles(MediaFileType.getMediaFileType(this.type));
        ArrayList<MediaFile> newMediaFiles = new ArrayList<MediaFile>();
        try {
            String firstFilename = this.filenames.get(0);
            LOGGER.debug("writing {} - {}", (Object)this.type, (Object)firstFilename);
            Path destFile = ImageUtils.downloadImage(this.url, this.entity.getPathNIO(), firstFilename);
            this.entity.removeAllMediaFiles(MediaFileType.getMediaFileType(this.type));
            for (MediaFile mediaFile : oldMediaFiles) {
                ImageCache.invalidateCachedImage(mediaFile.getFile());
                if (mediaFile.getFile().equals(destFile)) continue;
                Utils.deleteFileSafely(mediaFile.getFile());
            }
            newMediaFiles.add(new MediaFile(destFile, MediaFileType.getMediaFileType(this.type)));
            for (String string : this.filenames) {
                void var6_13;
                if (firstFilename.equals(string)) continue;
                if (FilenameUtils.getExtension((String)string).equalsIgnoreCase("JPEG")) {
                    String string2 = FilenameUtils.getBaseName((String)string) + ".jpg";
                }
                LOGGER.debug("writing {} - {}", (Object)this.type, (Object)var6_13);
                Path destFile2 = this.entity.getPathNIO().resolve((String)var6_13);
                Utils.copyFileSafe(destFile, destFile2, true);
                newMediaFiles.add(new MediaFile(destFile2, MediaFileType.getMediaFileType(this.type)));
            }
            boolean first = true;
            for (MediaFile artwork : newMediaFiles) {
                ImageCache.cacheImageSilently(artwork.getFile());
                if (first) {
                    this.entity.setArtwork(artwork.getFile(), MediaFileType.getMediaFileType(this.type));
                    this.entity.callbackForWrittenArtwork(this.type);
                    this.entity.saveToDb();
                    first = false;
                    continue;
                }
                artwork.gatherMediaInformation();
                this.entity.addToMediaFiles(artwork);
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("Could not fetch image '{}' - '{}'", (Object)this.url, (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"ArtworkDownload", "message.artwork.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
        }
    }
}

