/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.downloader.client;

import com.github.kiulian.downloader.downloader.client.Client;
import com.github.kiulian.downloader.downloader.client.ClientType;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

public class Clients {
    private static final SortedSet<Client> defaultClients;
    private static Client HIGHEST_PRIORITY_CLIENT;
    private static final int MANUALLY_DETERMINED_PRIORITY = Integer.MAX_VALUE;

    public static SortedSet<Client> defaultClients() {
        return defaultClients;
    }

    public static ClientType highestPriorityClientType() {
        return HIGHEST_PRIORITY_CLIENT.getType();
    }

    public static void setHighestPriorityClientType(ClientType clientType) {
        HIGHEST_PRIORITY_CLIENT = new Client(clientType);
    }

    static {
        Comparator comparator = ((Comparator)(client, client2) -> {
            if (client.getType() == client2.getType()) {
                return 0;
            }
            int n = Integer.compare(client.getPriority(), client2.getPriority());
            return n == 0 ? 1 : n;
        }).reversed();
        TreeSet<Client> treeSet = new TreeSet<Client>(comparator){

            @Override
            public boolean add(Client client) {
                if (HIGHEST_PRIORITY_CLIENT == null || client.getPriority() > HIGHEST_PRIORITY_CLIENT.getPriority()) {
                    HIGHEST_PRIORITY_CLIENT = client;
                }
                return super.add(client);
            }
        };
        treeSet.add(new Client(ClientType.WEB_HEROES, 59));
        treeSet.add(new Client(ClientType.TVHTML5_VR, 58));
        treeSet.add(new Client(ClientType.WEB_MUSIC_ANALYTICS, 57));
        treeSet.add(new Client(ClientType.ANDROID_VR, Integer.MAX_VALUE));
        treeSet.add(new Client(ClientType.WEB_MUSIC, 55));
        treeSet.add(new Client(ClientType.WEB, 54));
        treeSet.add(new Client(ClientType.TVHTML5_SIMPLY, 53));
        treeSet.add(new Client(ClientType.MWEB, 52));
        treeSet.add(new Client(ClientType.WEB_REMIX, 51));
        treeSet.add(new Client(ClientType.TVHTML5, 50));
        treeSet.add(new Client(ClientType.TVHTML5_CAST, 49));
        treeSet.add(new Client(ClientType.GOOGLE_LIST_RECS, 48));
        treeSet.add(new Client(ClientType.IOS_EMBEDDED_PLAYER, 47));
        treeSet.add(new Client(ClientType.ANDROID_TV, 46));
        treeSet.add(new Client(ClientType.IOS_MESSAGES_EXTENSION, 45));
        treeSet.add(new Client(ClientType.ANDROID_EMBEDDED_PLAYER, 44));
        treeSet.add(new Client(ClientType.IOS_LIVE_CREATION_EXTENSION, 43));
        treeSet.add(new Client(ClientType.WEB_PHONE_VERIFICATION, 42));
        treeSet.add(new Client(ClientType.IOS_PRODUCER, 41));
        treeSet.add(new Client(ClientType.WEB_EXPERIMENTS, 40));
        treeSet.add(new Client(ClientType.TVANDROID, 39));
        treeSet.add(new Client(ClientType.MWEB_TIER_2, 38));
        treeSet.add(new Client(ClientType.MUSIC_INTEGRATIONS, 37));
        treeSet.add(new Client(ClientType.MEDIA_CONNECT_FRONTEND, 36));
        treeSet.add(new Client(ClientType.IOS, 35));
        treeSet.add(new Client(ClientType.TVHTML5_YONGLE, 34));
        treeSet.add(new Client(ClientType.GOOGLE_ASSISTANT, 33));
        treeSet.add(new Client(ClientType.XBOXONEGUIDE, 32));
        treeSet.add(new Client(ClientType.WEB_INTERNAL_ANALYTICS, 31));
        treeSet.add(new Client(ClientType.GOOGLE_MEDIA_ACTIONS, 30));
        treeSet.add(new Client(ClientType.WEB_PARENT_TOOLS, 29));
        treeSet.add(new Client(ClientType.IOS_MUSIC, 28));
        treeSet.add(new Client(ClientType.ANDROID_MUSIC, 27));
        treeSet.add(new Client(ClientType.WEB_CREATOR, 26));
        treeSet.add(new Client(ClientType.IOS_CREATOR, 25));
        treeSet.add(new Client(ClientType.ANDROID_CREATOR, 24));
        treeSet.add(new Client(ClientType.ANDROID_LITE, 23));
        treeSet.add(new Client(ClientType.TVAPPLE, 22));
        treeSet.add(new Client(ClientType.TVLITE, 21));
        treeSet.add(new Client(ClientType.WEB_EMBEDDED_PLAYER, 20));
        treeSet.add(new Client(ClientType.TVHTML5_SIMPLY_EMBEDDED_PLAYER, 19));
        treeSet.add(new Client(ClientType.WEB_UNPLUGGED_OPS, 18));
        treeSet.add(new Client(ClientType.WEB_UNPLUGGED, 17));
        treeSet.add(new Client(ClientType.WEB_UNPLUGGED_ONBOARDING, 16));
        treeSet.add(new Client(ClientType.TV_UNPLUGGED_CAST, 15));
        treeSet.add(new Client(ClientType.TVHTML5_UNPLUGGED, 14));
        treeSet.add(new Client(ClientType.ANDROID_UNPLUGGED, 13));
        treeSet.add(new Client(ClientType.TV_UNPLUGGED_ANDROID, 12));
        treeSet.add(new Client(ClientType.WEB_UNPLUGGED_PUBLIC, 11));
        treeSet.add(new Client(ClientType.IOS_UNPLUGGED, 10));
        treeSet.add(new Client(ClientType.IOS_UPTIME, 9));
        treeSet.add(new Client(ClientType.IOS_KIDS, 8));
        treeSet.add(new Client(ClientType.ANDROID_TV_KIDS, 7));
        treeSet.add(new Client(ClientType.TVHTML5_AUDIO, 6));
        treeSet.add(new Client(ClientType.TVHTML5_FOR_KIDS, 5));
        treeSet.add(new Client(ClientType.ANDROID_KIDS, 4));
        treeSet.add(new Client(ClientType.TVHTML5_KIDS, 3));
        treeSet.add(new Client(ClientType.WEB_KIDS, 2));
        treeSet.add(new Client(ClientType.ANDROID, 1));
        treeSet.add(new Client(ClientType.ANDROID_TESTSUITE, 0));
        defaultClients = Collections.unmodifiableSortedSet(treeSet);
    }
}

