/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.downloader;

import com.github.kiulian.downloader.Config;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.downloader.Downloader;
import com.github.kiulian.downloader.downloader.YoutubeCallback;
import com.github.kiulian.downloader.downloader.YoutubeProgressCallback;
import com.github.kiulian.downloader.downloader.request.Request;
import com.github.kiulian.downloader.downloader.request.RequestVideoFileDownload;
import com.github.kiulian.downloader.downloader.request.RequestVideoStreamDownload;
import com.github.kiulian.downloader.downloader.request.RequestWebpage;
import com.github.kiulian.downloader.downloader.response.ResponseImpl;
import com.github.kiulian.downloader.model.Utils;
import com.github.kiulian.downloader.model.videos.formats.Format;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;

public class DownloaderImpl
implements Downloader {
    private static final int BUFFER_SIZE = 4096;
    private static final int PART_LENGTH = 0x200000;
    private final Config config;

    public DownloaderImpl(Config config) {
        this.config = config;
    }

    public ResponseImpl<String> downloadWebpage(RequestWebpage requestWebpage) {
        if (requestWebpage.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<String> future = executorService.submit(() -> this.download(requestWebpage));
            return ResponseImpl.fromFuture(future);
        }
        try {
            String string = this.download(requestWebpage);
            return ResponseImpl.from(string);
        }
        catch (YoutubeException | IOException exception) {
            return ResponseImpl.error(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String download(RequestWebpage requestWebpage) throws IOException, YoutubeException {
        Object object;
        IOException iOException;
        String string = requestWebpage.getDownloadUrl();
        Map<String, String> map = requestWebpage.getHeaders();
        YoutubeCallback youtubeCallback = requestWebpage.getCallback();
        int n = requestWebpage.getMaxRetries() != null ? requestWebpage.getMaxRetries().intValue() : this.config.getMaxRetries();
        Proxy proxy = requestWebpage.getProxy();
        StringBuilder stringBuilder = new StringBuilder();
        do {
            try {
                Object object2;
                int n2;
                object = this.openConnection(string, map, proxy, this.config.isCompressionEnabled());
                ((HttpURLConnection)object).setRequestMethod(requestWebpage.getMethod());
                if (requestWebpage.getBody() != null) {
                    ((URLConnection)object).setDoOutput(true);
                    try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(((URLConnection)object).getOutputStream(), StandardCharsets.UTF_8);){
                        outputStreamWriter.write(requestWebpage.getBody());
                        outputStreamWriter.flush();
                    }
                }
                if ((n2 = ((HttpURLConnection)object).getResponseCode()) != 200) {
                    YoutubeException.DownloadException downloadException = new YoutubeException.DownloadException("Failed to download: HTTP " + n2);
                    if (youtubeCallback != null) {
                        youtubeCallback.onError(downloadException);
                    }
                    throw downloadException;
                }
                int n3 = ((URLConnection)object).getContentLength();
                if (n3 == 0) {
                    object2 = new YoutubeException.DownloadException("Failed to download: Response is empty");
                    if (youtubeCallback != null) {
                        youtubeCallback.onError((Throwable)object2);
                    }
                    throw object2;
                }
                object2 = null;
                try {
                    String string2;
                    InputStream inputStream = ((URLConnection)object).getInputStream();
                    if (this.config.isCompressionEnabled() && "gzip".equals(((URLConnection)object).getHeaderField("content-encoding"))) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    object2 = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                        stringBuilder.append(string2).append('\n');
                    }
                }
                finally {
                    Utils.closeSilently((Closeable)object2);
                }
                iOException = null;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                --n;
            }
        } while (iOException != null && n > 0);
        if (iOException != null) {
            if (youtubeCallback != null) {
                youtubeCallback.onError(iOException);
            }
            throw iOException;
        }
        object = stringBuilder.toString();
        if (youtubeCallback != null) {
            youtubeCallback.onFinished(object);
        }
        return object;
    }

    public ResponseImpl<File> downloadVideoAsFile(RequestVideoFileDownload requestVideoFileDownload) {
        if (requestVideoFileDownload.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<File> future = executorService.submit(() -> this.download(requestVideoFileDownload));
            return ResponseImpl.fromFuture(future);
        }
        try {
            File file = this.download(requestVideoFileDownload);
            return ResponseImpl.from(file);
        }
        catch (IOException iOException) {
            return ResponseImpl.error(iOException);
        }
    }

    public ResponseImpl<Void> downloadVideoAsStream(RequestVideoStreamDownload requestVideoStreamDownload) {
        if (requestVideoStreamDownload.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<Void> future = executorService.submit(() -> this.download(requestVideoStreamDownload));
            return ResponseImpl.fromFuture(future);
        }
        try {
            this.download(requestVideoStreamDownload);
            return ResponseImpl.from(null);
        }
        catch (IOException iOException) {
            return ResponseImpl.error(iOException);
        }
    }

    private File download(RequestVideoFileDownload requestVideoFileDownload) throws IOException {
        Format format = requestVideoFileDownload.getFormat();
        File file = requestVideoFileDownload.getOutputFile();
        YoutubeCallback youtubeCallback = requestVideoFileDownload.getCallback();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.download(requestVideoFileDownload, format, fileOutputStream);
        if (youtubeCallback != null) {
            youtubeCallback.onFinished(file);
        }
        return file;
    }

    private Void download(RequestVideoStreamDownload requestVideoStreamDownload) throws IOException {
        Format format = requestVideoStreamDownload.getFormat();
        YoutubeCallback youtubeCallback = requestVideoStreamDownload.getCallback();
        OutputStream outputStream = requestVideoStreamDownload.getOutputStream();
        this.download(requestVideoStreamDownload, format, outputStream);
        if (youtubeCallback != null) {
            youtubeCallback.onFinished(null);
        }
        return null;
    }

    private void download(Request<?, ?> request, Format format, OutputStream outputStream) throws IOException {
        IOException iOException;
        Map<String, String> map = request.getHeaders();
        YoutubeCallback<?> youtubeCallback = request.getCallback();
        int n = request.getMaxRetries() != null ? request.getMaxRetries().intValue() : this.config.getMaxRetries();
        Proxy proxy = request.getProxy();
        do {
            try {
                if (format.isAdaptive() && format.contentLength() != null) {
                    this.downloadByPart(format, outputStream, map, proxy, youtubeCallback);
                } else {
                    this.downloadStraight(format, outputStream, map, proxy, youtubeCallback);
                }
                iOException = null;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        } while (iOException != null && n-- > 0);
        Utils.closeSilently(outputStream);
        if (iOException != null) {
            if (youtubeCallback != null) {
                youtubeCallback.onError(iOException);
            }
            throw iOException;
        }
    }

    private void downloadStraight(Format format, OutputStream outputStream, Map<String, String> map, Proxy proxy, YoutubeCallback<?> youtubeCallback) throws IOException {
        HttpURLConnection httpURLConnection = this.openConnection(format.url(), map, proxy, false);
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            throw new RuntimeException("Failed to download: HTTP " + n);
        }
        int n2 = httpURLConnection.getContentLength();
        InputStream inputStream = httpURLConnection.getInputStream();
        byte[] byArray = new byte[4096];
        if (youtubeCallback == null) {
            DownloaderImpl.copyAndCloseInput(inputStream, outputStream, byArray);
        } else {
            DownloaderImpl.copyAndCloseInput(inputStream, outputStream, byArray, 0L, n2, youtubeCallback);
        }
    }

    private void downloadByPart(Format format, OutputStream outputStream, Map<String, String> map, Proxy proxy, YoutubeCallback<?> youtubeCallback) throws IOException {
        long l = 0L;
        int n = 0;
        String string = "&cver=" + format.clientVersion() + "&range=";
        long l2 = format.contentLength();
        byte[] byArray = new byte[4096];
        while (l < l2) {
            String string2;
            HttpURLConnection httpURLConnection;
            int n2;
            long l3 = 0x200000L;
            if (l + l3 > l2) {
                l3 = (int)(l2 - l);
            }
            if ((n2 = (httpURLConnection = this.openConnection(string2 = format.url() + string + l + "-" + (l + l3 - 1L) + "&rn=" + ++n, map, proxy, false)).getResponseCode()) != 200) {
                throw new RuntimeException("Failed to download: HTTP " + n2);
            }
            InputStream inputStream = httpURLConnection.getInputStream();
            if (youtubeCallback == null) {
                l += DownloaderImpl.copyAndCloseInput(inputStream, outputStream, byArray);
                continue;
            }
            l += DownloaderImpl.copyAndCloseInput(inputStream, outputStream, byArray, l, l2, youtubeCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyAndCloseInput(InputStream inputStream, OutputStream outputStream, byte[] byArray, long l, long l2, YoutubeCallback<?> youtubeCallback) throws IOException {
        long l3 = 0L;
        try {
            long l4;
            int n = 0;
            long l5 = l4 = l == 0L ? 0L : l * 100L / l2;
            while ((n = inputStream.read(byArray)) != -1) {
                if (Thread.interrupted()) {
                    throw new CancellationException();
                }
                outputStream.write(byArray, 0, n);
                long l6 = (l + (l3 += (long)n)) * 100L / l2;
                if (l6 <= l4) continue;
                if (youtubeCallback instanceof YoutubeProgressCallback) {
                    ((YoutubeProgressCallback)youtubeCallback).onDownloading((int)l6);
                }
                l4 = l6;
            }
        }
        finally {
            Utils.closeSilently(inputStream);
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyAndCloseInput(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l = 0L;
        try {
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                if (Thread.interrupted()) {
                    throw new CancellationException();
                }
                outputStream.write(byArray, 0, n);
                l += (long)n;
            }
        }
        finally {
            Utils.closeSilently(inputStream);
        }
        return l;
    }

    private HttpURLConnection openConnection(String string, Map<String, String> map, Proxy proxy, boolean bl) throws IOException {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = proxy != null ? (HttpURLConnection)uRL.openConnection(proxy) : (this.config.getProxy() != null ? (HttpURLConnection)uRL.openConnection(this.config.getProxy()) : (HttpURLConnection)uRL.openConnection());
        for (Map.Entry<String, String> entry : this.config.getHeaders().entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (bl) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
        }
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return httpURLConnection;
    }
}

