/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.label;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.components.label.ImageLabel;

public class PersonImageLabel
extends ImageLabel {
    private SwingWorker<Void, Void> personWorker = null;
    private Person person = null;

    public PersonImageLabel() {
        this.drawNoImage = false;
        this.cacheUrl = true;
    }

    public void setPerson(MediaEntity mediaEntity, Person person) {
        this.clearImage();
        if (mediaEntity != null && person != null && person != this.person) {
            if (this.personWorker != null && !this.personWorker.isDone()) {
                this.personWorker.cancel(true);
            }
            this.person = person;
            this.personWorker = new ActorImageLoader(person, mediaEntity);
            this.personWorker.execute();
        }
    }

    @Override
    public void clearImage() {
        super.clearImage();
        this.person = null;
    }

    protected class ActorImageLoader
    extends SwingWorker<Void, Void> {
        private final Person actor;
        private final MediaEntity mediaEntity;
        private Path imagePath = null;
        private String imageUrl = null;

        private ActorImageLoader(Person actor, MediaEntity mediaEntity) {
            this.actor = actor;
            this.mediaEntity = mediaEntity;
        }

        @Override
        protected Void doInBackground() {
            String actorImageFilename = this.actor.getNameForStorage();
            if (StringUtils.isNotBlank((CharSequence)actorImageFilename)) {
                Path file = null;
                if (Settings.getInstance().isImageCache()) {
                    file = ImageCache.getCachedFile(Paths.get(this.mediaEntity.getPath(), ".actors", actorImageFilename));
                }
                if (file == null) {
                    file = Paths.get(this.mediaEntity.getPath(), ".actors", actorImageFilename);
                }
                if (Files.exists(file, new LinkOption[0])) {
                    this.imagePath = file;
                    return null;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.actor.getThumbUrl())) {
                if (!Settings.getInstance().isImageCache()) {
                    Path p = ImageCache.getCachedFile(this.actor.getThumbUrl());
                    if (p != null) {
                        this.imagePath = p;
                    }
                } else {
                    this.imageUrl = this.actor.getThumbUrl();
                }
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            if (this.imagePath != null) {
                PersonImageLabel.this.setImagePath(this.imagePath.toString());
            } else if (StringUtils.isNotBlank((CharSequence)this.imageUrl)) {
                PersonImageLabel.this.setImageUrl(this.imageUrl);
            } else {
                PersonImageLabel.this.clearImage();
            }
        }
    }
}

