/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.index;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.index.BDJIndexObject;
import org.tinymediamanager.library.bluray.index.HDMVIndexObject;
import org.tinymediamanager.library.bluray.index.IndexObject;

public class Title {
    IndexObject titleObject;
    TitleAccessType type;

    public void setIndexObject(IndexObject indexObject) {
        this.titleObject = indexObject;
    }

    public IndexObject getIndexObject() {
        return this.titleObject;
    }

    public void setTitleAccessType(TitleAccessType titleAccessType) {
        this.type = titleAccessType;
    }

    public TitleAccessType getTitleAccessType() {
        return this.type;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        dataInputStream.skipBytes(3);
        int n = (by & 0xC0) >> 6;
        this.titleObject = n == 1 ? new HDMVIndexObject() : new BDJIndexObject();
        int n2 = (by & 0x30) >> 4;
        TitleAccessType[] titleAccessTypeArray = TitleAccessType.values();
        for (int i = 0; i < titleAccessTypeArray.length; ++i) {
            if (titleAccessTypeArray[i].ordinal() != n2) continue;
            this.setTitleAccessType(titleAccessTypeArray[i]);
            break;
        }
        this.titleObject.readObject(dataInputStream);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n = this.getTitleAccessType().ordinal() << 4 | this.titleObject.getObjectType().ordinal() << 6;
        byte[] byArray = new byte[3];
        dataOutputStream.writeByte(n);
        dataOutputStream.write(byArray);
        this.titleObject.writeObject(dataOutputStream);
    }

    public static enum TitleAccessType {
        V_00,
        V_01,
        V_10,
        V_11;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }
}

