/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLBAddr;

public class LBAddr {
    public Long blockNumber;
    public Integer partitionReferenceNumber;
    public static final int LENGTH = 6;

    public LBAddr(byte[] byArray) throws InvalidLBAddr {
        this.deserialize(byArray);
    }

    public void deserialize(byte[] byArray) throws InvalidLBAddr {
        if (byArray.length < 6) {
            throw new InvalidLBAddr("logical block address descriptor too short");
        }
        this.blockNumber = UDFUtil.getUInt32(byArray, 0);
        this.partitionReferenceNumber = UDFUtil.getUInt16(byArray, 4);
    }

    public String toString() {
        return "LBAddr [blockNumber=" + this.blockNumber + ", partitionReferenceNumber=" + this.partitionReferenceNumber + "]";
    }
}

