/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.addon.YtDlpAddon;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;

public class TvShowTrailerOptionsSettingsPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener;
    private final ButtonGroup trailerFilenameButtonGroup = new ButtonGroup();
    private JComboBox<TrailerSources> cbTrailerSource;
    private JComboBox<TrailerQuality> cbTrailerQuality;
    private JCheckBox checkBox;
    private JCheckBox chckbxAutomaticTrailerDownload;
    private JRadioButton rbTrailerFilename1;
    private JRadioButton rbTrailerFilename2;
    private JRadioButton rbTrailerFilename3;
    private JRadioButton rbTrailerFilename4;
    private JCheckBox chckbxUseYtDlp;
    private JLabel lblAutomaticTrailerDownloadHint;

    TvShowTrailerOptionsSettingsPanel() {
        this.checkBoxListener = e -> this.checkChanges();
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
            }
        });
        this.initComponents();
        this.initDataBindings();
        this.buildCheckBoxes();
        this.chckbxUseYtDlp.setEnabled(new YtDlpAddon().isAvailable());
    }

    private void buildCheckBoxes() {
        this.clearSelection(this.rbTrailerFilename1, this.rbTrailerFilename2, this.rbTrailerFilename3, this.rbTrailerFilename4);
        List<TvShowTrailerNaming> trailerFilenames = this.settings.getTrailerFilenames();
        if (trailerFilenames.contains(TvShowTrailerNaming.TVSHOW_TRAILER)) {
            this.rbTrailerFilename1.setSelected(true);
        } else if (trailerFilenames.contains(TvShowTrailerNaming.TVSHOWNAME_TRAILER)) {
            this.rbTrailerFilename2.setSelected(true);
        } else if (trailerFilenames.contains(TvShowTrailerNaming.TRAILERS_TVSHOWNAME_TRAILER)) {
            this.rbTrailerFilename3.setSelected(true);
        } else if (trailerFilenames.contains(TvShowTrailerNaming.TRAILER)) {
            this.rbTrailerFilename4.setSelected(true);
        }
        this.rbTrailerFilename1.addItemListener(this.checkBoxListener);
        this.rbTrailerFilename2.addItemListener(this.checkBoxListener);
        this.rbTrailerFilename3.addItemListener(this.checkBoxListener);
        this.rbTrailerFilename4.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JToggleButton ... toggleButtons) {
        for (JToggleButton button : toggleButtons) {
            button.removeItemListener(this.checkBoxListener);
            button.setSelected(false);
        }
    }

    private void checkChanges() {
        this.settings.clearTrailerFilenames();
        if (this.rbTrailerFilename1.isSelected()) {
            this.settings.addTrailerFilename(TvShowTrailerNaming.TVSHOW_TRAILER);
        }
        if (this.rbTrailerFilename2.isSelected()) {
            this.settings.addTrailerFilename(TvShowTrailerNaming.TVSHOWNAME_TRAILER);
        }
        if (this.rbTrailerFilename3.isSelected()) {
            this.settings.addTrailerFilename(TvShowTrailerNaming.TRAILERS_TVSHOWNAME_TRAILER);
        }
        if (this.rbTrailerFilename4.isSelected()) {
            this.settings.addTrailerFilename(TvShowTrailerNaming.TRAILER);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 0", "[grow]", "[]"));
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][]"));
        TmmLabel lblOptionsT = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptionsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#advanced-options-2"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.chckbxUseYtDlp = new JHintCheckBox(TmmResourceBundle.getString("Settings.trailer.ytdlp"));
        this.chckbxUseYtDlp.setToolTipText(TmmResourceBundle.getString("Settings.trailer.ytdlp.desc"));
        panelOptions.add((Component)this.chckbxUseYtDlp, "cell 1 0 2 1");
        this.checkBox = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.preferred"));
        panelOptions.add((Component)this.checkBox, "cell 1 1 2 1");
        JLabel lblTrailerSource = new JLabel(TmmResourceBundle.getString("Settings.trailer.source"));
        panelOptions.add((Component)lblTrailerSource, "cell 2 2");
        this.cbTrailerSource = new JComboBox();
        this.cbTrailerSource.setModel(new DefaultComboBoxModel<TrailerSources>(TrailerSources.getActiveTrailerSources()));
        panelOptions.add(this.cbTrailerSource, "cell 2 2");
        JLabel lblTrailerQuality = new JLabel(TmmResourceBundle.getString("Settings.trailer.quality"));
        panelOptions.add((Component)lblTrailerQuality, "cell 2 3");
        this.cbTrailerQuality = new JComboBox();
        this.cbTrailerQuality.setModel(new DefaultComboBoxModel<TrailerQuality>(TrailerQuality.values()));
        panelOptions.add(this.cbTrailerQuality, "cell 2 3");
        this.chckbxAutomaticTrailerDownload = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.automaticdownload"));
        panelOptions.add((Component)this.chckbxAutomaticTrailerDownload, "cell 2 4");
        this.lblAutomaticTrailerDownloadHint = new JLabel(TmmResourceBundle.getString("Settings.trailer.automaticdownload.hint"));
        panelOptions.add((Component)this.lblAutomaticTrailerDownloadHint, "cell 2 5");
        TmmFontHelper.changeFont((JComponent)this.lblAutomaticTrailerDownloadHint, 0.83333);
        JPanel panelTrailerFilenames = new JPanel();
        panelOptions.add((Component)panelTrailerFilenames, "cell 1 6 2 1");
        panelTrailerFilenames.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][][]"));
        JLabel lblTrailerFileNaming = new JLabel(TmmResourceBundle.getString("Settings.trailerFileNaming"));
        panelTrailerFilenames.add((Component)lblTrailerFileNaming, "cell 0 0");
        this.rbTrailerFilename1 = new JRadioButton("tvshow-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.rbTrailerFilename1);
        panelTrailerFilenames.add((Component)this.rbTrailerFilename1, "cell 1 0");
        this.rbTrailerFilename2 = new JRadioButton(TmmResourceBundle.getString("Settings.trailer.tvshowtitle") + "-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.rbTrailerFilename2);
        panelTrailerFilenames.add((Component)this.rbTrailerFilename2, "cell 1 1");
        this.rbTrailerFilename3 = new JRadioButton("trailers/" + TmmResourceBundle.getString("Settings.trailer.tvshowtitle") + "-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.rbTrailerFilename3);
        panelTrailerFilenames.add((Component)this.rbTrailerFilename3, "cell 1 2");
        this.rbTrailerFilename4 = new JRadioButton("trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.rbTrailerFilename4);
        panelTrailerFilenames.add((Component)this.rbTrailerFilename4, "cell 1 3");
    }

    protected void initDataBindings() {
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"trailerSource");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, this.cbTrailerSource, (Property)jComboBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"trailerQuality");
        BeanProperty jComboBoxBeanProperty_1 = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, this.cbTrailerQuality, (Property)jComboBoxBeanProperty_1);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"useTrailerPreference");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.checkBox, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"automaticTrailerDownload");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"useYtDlp");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.chckbxUseYtDlp, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.checkBox, (Property)jCheckBoxBeanProperty, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty_1);
        autoBinding.bind();
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.checkBox, (Property)jCheckBoxBeanProperty, (Object)this.lblAutomaticTrailerDownloadHint, (Property)jCheckBoxBeanProperty_1);
        autoBinding_6.bind();
    }
}

