/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowVideoContainerFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowVideoContainerFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallVideoContainerArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallVideoContainerArray());
    }

    @Override
    public String getId() {
        return "tvShowVideoContainer";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            String container = episode.getMediaInfoContainerFormat();
            for (String value : selectedValues) {
                if (!(invert ^ value.equalsIgnoreCase(container))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.container"));
    }

    private void buildAndInstallVideoContainerArray() {
        HashSet<String> videoContainersInEpisodes = new HashSet<String>(this.tvShowList.getVideoContainersInEpisodes());
        if (!SetUtils.equals(this.oldValues, videoContainersInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(videoContainersInEpisodes);
            List<String> sortedVideoContainers = ListUtils.asSortedList(videoContainersInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedVideoContainers));
        }
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

