/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowSubtitleCountFilter
extends AbstractCheckComboBoxTvShowUIFilter<Integer> {
    public TvShowSubtitleCountFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith((String)s2));
        this.buildAndInstallSubtitleCountArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallSubtitleCountArray());
    }

    @Override
    protected String parseTypeToString(Integer type) throws Exception {
        return type.toString();
    }

    @Override
    protected Integer parseStringToType(String string) throws Exception {
        return Integer.parseInt(string);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            if (!(invert ^ selectedItems.contains(episode.getMediaInfoSubtitleStreamCount()))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitles"));
    }

    @Override
    public String getId() {
        return "tvShowSubtitleCount";
    }

    private void buildAndInstallSubtitleCountArray() {
        HashSet<Integer> subtitleCountInEpisodes = new HashSet<Integer>(this.tvShowList.getSubtitlesInEpisodes());
        if (!SetUtils.equals(this.oldValues, subtitleCountInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(subtitleCountInEpisodes);
            List<Integer> sortedSubtitleCount = ListUtils.asSortedList(subtitleCountInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedSubtitleCount));
        }
    }
}

