/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieTagFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private final Comparator<String> comparator;

    public MovieTagFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.comparator = new TmmTableFormat.StringComparator();
        this.buildAndInstallTagsArray();
        EventBus.registerListener("movies-ui", event -> this.buildAndInstallTagsArray());
    }

    @Override
    public String getId() {
        return "movieTag";
    }

    @Override
    public boolean accept(Movie movie) {
        List tags = this.checkComboBox.getSelectedItems();
        if (tags.isEmpty() && movie.getTags().isEmpty()) {
            return true;
        }
        for (String tag : movie.getTags()) {
            if (!tags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.tag"));
    }

    private void buildAndInstallTagsArray() {
        HashSet<String> tags = new HashSet<String>(this.movieList.getTagsInMovies());
        if (!SetUtils.equals(this.oldValues, tags)) {
            this.oldValues.clear();
            this.oldValues.addAll(tags);
            List<String> sortedTags = ListUtils.asSortedList(tags, this.comparator);
            SwingUtilities.invokeLater(() -> this.setValues(sortedTags));
        }
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

