/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.images;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.net.URI;
import org.tinymediamanager.ui.images.SvgIconHelper;

public class TmmSvgIcon
extends SVGIcon {
    protected TmmSvgIcon() {
        this.setSvgUniverse(new SVGUniverse());
        this.setAutosize(3);
        this.setAntiAlias(true);
        this.setInterpolation(2);
        this.setClipToViewbox(false);
    }

    public TmmSvgIcon(URI uri) {
        this();
        this.setSvgURI(uri);
    }

    public void setPreferredHeight(int height) {
        SVGDiagram diagram = this.getSvgUniverse().getDiagram(this.getSvgURI());
        if (diagram != null) {
            this.setPreferredSize(new Dimension((int)(diagram.getWidth() * (float)height / diagram.getHeight()), height));
        }
    }

    public SVGElement getElement(String id) {
        return this.getSvgUniverse().getElement(this.getSvgURI().resolve("#" + id));
    }

    public void setColor(Color color) {
        if (color != null) {
            try {
                SVGDiagram diagram = this.getSvgUniverse().getDiagram(this.getSvgURI());
                SvgIconHelper.setFill(SvgIconHelper.getHexString(color), (SVGElement)diagram.getRoot());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setColor(Color color, String originalToReplace) {
        if (color != null) {
            try {
                SVGDiagram diagram = this.getSvgUniverse().getDiagram(this.getSvgURI());
                SvgIconHelper.setFill(SvgIconHelper.getHexString(color), originalToReplace, (SVGElement)diagram.getRoot());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

