/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.tmdb.TmdbController;
import org.tinymediamanager.scraper.tmdb.entities.FindResults;
import org.tinymediamanager.scraper.tmdb.enumerations.ExternalSource;
import org.tinymediamanager.scraper.util.ListUtils;

class TmdbUtils {
    private TmdbUtils() {
        throw new IllegalAccessError();
    }

    static int getTmdbIdFromImdbId(TmdbController api, MediaType type, String imdbId) throws Exception {
        FindResults findResults = (FindResults)api.findService().find(imdbId, ExternalSource.IMDB_ID, null).execute().body();
        if (findResults == null) {
            return 0;
        }
        if (ListUtils.isNotEmpty(findResults.movie_results) && (type == MediaType.MOVIE || type == MediaType.MOVIE_SET)) {
            return findResults.movie_results.get((int)0).id;
        }
        if (ListUtils.isNotEmpty(findResults.tv_results) && type == MediaType.TV_SHOW) {
            return findResults.tv_results.get((int)0).id;
        }
        if (ListUtils.isNotEmpty(findResults.tv_episode_results) && type == MediaType.TV_EPISODE) {
            return findResults.tv_episode_results.get((int)0).id;
        }
        return 0;
    }

    static int getTmdbIdFromTvdbId(TmdbController api, int tvdbId) throws Exception {
        FindResults findResults = (FindResults)api.findService().find(tvdbId, ExternalSource.TVDB_ID, null).execute().body();
        if (findResults != null && findResults.tv_results != null && !findResults.tv_results.isEmpty()) {
            return findResults.tv_results.get((int)0).id;
        }
        return 0;
    }
}

