/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.filenaming.TvShowExtraFanartNaming;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class TvShowExtraImageFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowExtraImageFetcherTask.class);
    private final TvShow tvShow;
    private final MediaFileType type;
    private final List<TvShowExtraFanartNaming> extraFanartNamings;

    public TvShowExtraImageFetcherTask(TvShow tvShow, MediaFileType type) {
        this.tvShow = tvShow;
        this.type = type;
        this.extraFanartNamings = new ArrayList<TvShowExtraFanartNaming>(TvShowModuleManager.getInstance().getSettings().getExtraFanartFilenames());
    }

    @Override
    public void run() {
        try {
            boolean ok = this.downloadExtraFanart();
            if (Thread.interrupted()) {
                return;
            }
            if (ok) {
                this.tvShow.callbackForWrittenArtwork(MediaArtwork.MediaArtworkType.ALL);
                this.tvShow.saveToDb();
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not download extra artwork for TV show '{}' - '{}'", (Object)this.tvShow.getTitle(), (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "message.extraimage.threadcrashed"));
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean downloadExtraFanart() {
        fanartUrls = this.tvShow.getExtraFanartUrls();
        if (fanartUrls.isEmpty()) {
            return false;
        }
        if (this.extraFanartNamings.isEmpty()) {
            return false;
        }
        for (MediaFile mediaFile : this.tvShow.getMediaFiles(new MediaFileType[]{MediaFileType.EXTRAFANART})) {
            Utils.deleteFileSafely(mediaFile.getFile());
            this.tvShow.removeFromMediaFiles(mediaFile);
        }
        fileNaming = this.extraFanartNamings.get(0);
        if (fileNaming == TvShowExtraFanartNaming.FOLDER_EXTRAFANART) {
            folder = this.tvShow.getPathNIO().resolve("extrafanart");
            try {
                if (Files.exists(folder, new LinkOption[0])) ** GOTO lbl23
                Files.createDirectory(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                TvShowExtraImageFetcherTask.LOGGER.error("Could not create extrafanarts folder for TV show '{}' - '{}'", (Object)this.tvShow.getTitle(), (Object)e.getMessage());
                return false;
            }
        } else {
            folder = this.tvShow.getPathNIO();
        }
lbl23:
        // 3 sources

        i = 1;
        for (String urlAsString : fanartUrls) {
            try {
                extension = Utils.getArtworkExtensionFromUrl(urlAsString);
                filename = fileNaming.getFilename("", extension);
                basename = FilenameUtils.getBaseName((String)filename);
                filename = basename + i + "." + extension;
                destFile = ImageUtils.downloadImage(urlAsString, folder, (String)filename);
                mf = new MediaFile(destFile, MediaFileType.EXTRAFANART);
                mf.gatherMediaInformation();
                this.tvShow.addToMediaFiles(mf);
                ImageCache.invalidateCachedImage(destFile);
                ImageCache.cacheImageSilently(destFile);
                ++i;
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                TvShowExtraImageFetcherTask.LOGGER.warn("Problem downloading extrafanart for TV show '{}' - '{}'", (Object)this.tvShow.getTitle(), (Object)e.getMessage());
            }
        }
        return true;
    }
}

