/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;

public class QueueTask
extends TmmTask {
    private final Queue<TmmTask> taskQueue = new LinkedBlockingQueue<TmmTask>();
    private TmmTask activeTask = null;

    public QueueTask(String taskName) {
        super(taskName, 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
    }

    public void addTask(TmmTask task) {
        this.taskQueue.add(task);
    }

    @Override
    protected void doInBackground() {
        this.setWorkUnits(this.taskQueue.size() + 1);
        int counter = 1;
        while (!this.cancel) {
            this.activeTask = this.taskQueue.poll();
            if (this.activeTask == null) break;
            this.setTaskDescription(this.activeTask.getTaskName());
            this.activeTask.run();
            this.setProgressDone(++counter);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        TmmTask task = this.activeTask;
        if (task != null) {
            task.cancel();
        }
    }
}

