/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;

public class MediaFileInformationFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFileInformationFetcherTask.class);
    protected final MediaFile mediaFile;
    protected final MediaEntity mediaEntity;
    private final long uniqueId;
    private final boolean forceUpdate;

    public MediaFileInformationFetcherTask(MediaFile mediaFile, MediaEntity mediaEntity, boolean forceUpdate) {
        this.mediaFile = mediaFile;
        this.mediaEntity = mediaEntity;
        this.forceUpdate = forceUpdate;
        this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
    }

    @Override
    public void run() {
        try {
            Path xmlFile;
            Object name = Thread.currentThread().getName();
            if (!((String)name).contains("-G")) {
                name = (String)name + "-G0";
            }
            name = ((String)name).replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName((String)name);
            this.mediaFile.gatherMediaInformation(this.forceUpdate);
            if (this.mediaFile.getType() == MediaFileType.SUBTITLE || this.mediaFile.getType() == MediaFileType.AUDIO) {
                MediaFile mainVideoFile = this.mediaEntity.getMainFile();
                boolean goOn = true;
                if (this.mediaEntity instanceof Movie && ((Movie)this.mediaEntity).isMultiMovieDir() && (!StringUtils.isNotBlank((CharSequence)mainVideoFile.getBasename()) || !this.mediaFile.getFilename().startsWith(mainVideoFile.getBasename()))) {
                    goOn = false;
                }
                if (goOn) {
                    MediaStreamInfo info = MediaFileHelper.gatherLanguageInformation(this.mediaFile.getBasename(), mainVideoFile.getBasename());
                    if (this.mediaFile.getType() == MediaFileType.SUBTITLE && !this.mediaFile.getSubtitles().isEmpty()) {
                        MediaFileSubtitle sub = this.mediaFile.getSubtitles().get(0);
                        if (sub.getLanguage().isEmpty() || info.getLanguage().matches("[a-zA-Z][a-zA-Z][_-].*")) {
                            sub.setLanguage(info.getLanguage());
                        }
                        sub.setTitle(info.getTitle());
                        sub.set(info.getFlags());
                    } else if (this.mediaFile.getType() == MediaFileType.AUDIO && !this.mediaFile.getAudioStreams().isEmpty()) {
                        MediaFileAudioStream audio = this.mediaFile.getAudioStreams().get(0);
                        if (StringUtils.isBlank((CharSequence)audio.getLanguage()) || info.getLanguage().matches("[a-zA-Z][a-zA-Z][_-].*")) {
                            audio.setLanguage(info.getLanguage());
                        }
                        if (StringUtils.isBlank((CharSequence)audio.getTitle())) {
                            audio.setTitle(info.getTitle());
                        }
                        audio.set(info.getFlags());
                    }
                }
            }
            if (this.mediaFile.hasSubtitles()) {
                this.mediaEntity.firePropertyChange("hasSubtitles", false, true);
            }
            if (Settings.getInstance().isWriteMediaInfoXml() && this.mediaFile.getType() == MediaFileType.VIDEO && Files.exists(xmlFile = Paths.get(this.mediaFile.getPath(), this.mediaFile.getMediaInfoXmlFilename()), new LinkOption[0])) {
                MediaFile xmlMf = new MediaFile(xmlFile);
                xmlMf.gatherMediaInformation();
                this.mediaEntity.addToMediaFiles(xmlMf);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not load MediaInfo - '{}'", (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MediaInformation", "message.mediainfo.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
        }
        if (this.mediaEntity != null) {
            this.mediaEntity.callbackForGatheredMediainformation(this.mediaFile);
            this.mediaEntity.saveToDb();
            this.mediaEntity.firePropertyChange("mediaInformation", false, true);
        }
        this.callbackForGatheredMediainformation();
    }

    public void callbackForGatheredMediainformation() {
    }
}

