/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.downloader.request;

import com.github.kiulian.downloader.downloader.request.Request;
import com.github.kiulian.downloader.model.Utils;
import com.github.kiulian.downloader.model.videos.formats.Format;
import java.io.File;
import java.util.UUID;

public class RequestVideoFileDownload
extends Request<RequestVideoFileDownload, File> {
    private File outputDirectory = new File("videos");
    private boolean overwrite = false;
    private String fileName = UUID.randomUUID().toString();
    private final Format format;

    public RequestVideoFileDownload(Format format) {
        this.format = format;
    }

    public RequestVideoFileDownload saveTo(File file) {
        this.outputDirectory = file;
        return this;
    }

    public RequestVideoFileDownload renameTo(String string) {
        this.fileName = string;
        return this;
    }

    public RequestVideoFileDownload overwriteIfExists(boolean bl) {
        this.overwrite = bl;
        return this;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public Format getFormat() {
        return this.format;
    }

    public File getOutputFile() {
        String string = Utils.removeIllegalChars(this.fileName);
        String string2 = string + "." + this.format.extension().value();
        File file = new File(this.outputDirectory, string2);
        if (!this.overwrite) {
            int n = 1;
            while (file.exists()) {
                string2 = string + "(" + n++ + ")." + this.format.extension().value();
                file = new File(file.getParentFile(), string2);
            }
        }
        return file;
    }
}

