/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.xmlcreator.XmlElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    private XMLUtil() {
    }

    public static Element getOnlyChildElement(NodeList list) throws XMLRPCException {
        Element e = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() == 3 && n.getNodeValue().trim().length() <= 0 || n.getNodeType() == 8) continue;
            if (n.getNodeType() != 1) {
                throw new XMLRPCException("Only element nodes allowed.");
            }
            if (e != null) {
                throw new XMLRPCException("Element has more than one children.");
            }
            e = (Element)n;
        }
        return e;
    }

    public static String getOnlyTextContent(NodeList list) throws XMLRPCException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() == 8) continue;
            if (n.getNodeType() != 3) {
                throw new XMLRPCException("Element must contain only text elements.");
            }
            builder.append(n.getNodeValue());
        }
        return builder.toString();
    }

    public static boolean hasChildElement(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static XmlElement makeXmlTag(String type, String content) {
        XmlElement xml = new XmlElement(type);
        xml.setContent(content);
        return xml;
    }
}

