/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowAudioStreamCountFilter
extends AbstractCheckComboBoxTvShowUIFilter<Integer> {
    public TvShowAudioStreamCountFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith((String)s2));
        this.buildAndInstallAudioStreamCountArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallAudioStreamCountArray());
    }

    @Override
    protected String parseTypeToString(Integer type) throws Exception {
        return type.toString();
    }

    @Override
    protected Integer parseStringToType(String string) throws Exception {
        return Integer.parseInt(string);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            if (!(invert ^ selectedItems.contains(episode.getMediaInfoAudioStreamCount()))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.countAudioStreams"));
    }

    @Override
    public String getId() {
        return "countAudioStreamsTvShow";
    }

    private void buildAndInstallAudioStreamCountArray() {
        HashSet<Integer> audioStreamCountInEpisodes = new HashSet<Integer>(this.tvShowList.getAudioStreamsInEpisodes());
        if (!SetUtils.equals(this.oldValues, audioStreamCountInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(audioStreamCountInEpisodes);
            List<Integer> sortedAudioStreamCount = ListUtils.asSortedList(audioStreamCountInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedAudioStreamCount));
        }
    }
}

