/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRebuildImageCacheAction
extends TmmAction {
    public TvShowRebuildImageCacheAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.rebuildimagecache"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.rebuildimagecache"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        if (!Settings.getInstance().isImageCache()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.imagecache.notactivated"));
            return;
        }
        final TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        TmmTask task = new TmmTask(TmmResourceBundle.getString("tmm.rebuildimagecache"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                HashSet<MediaFile> imageFiles = new HashSet<MediaFile>();
                for (TvShow tvShow : selectedObjects.getTvShows()) {
                    imageFiles.addAll(tvShow.getImagesToCache());
                }
                for (TvShowSeason season : selectedObjects.getSeasonsRecursive()) {
                    imageFiles.addAll(season.getImagesToCache());
                }
                for (TvShowEpisode episode : selectedObjects.getEpisodesRecursive()) {
                    imageFiles.addAll(episode.getImagesToCache());
                }
                ImageCache.clearImageCache(imageFiles);
                imageFiles.forEach(ImageCache::cacheImageAsync);
            }
        };
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

