/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.MediaIdTable;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.IdEditorPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;

public class PersonEditorPanel
extends AbstractModalInputPanel {
    private final EventList<MediaIdTable.MediaId> ids;
    private final Person person;
    private final JComboBox<Person.Type> cbType;
    private final JTextField tfName;
    private final JTextField tfRole;
    private final JTextField tfImageUrl;
    private final JTextField tfProfileUrl;
    private final TmmTable tableIds;

    public PersonEditorPanel(Person person, Person.Type[] allowedTyes) {
        this.person = person;
        this.ids = MediaIdTable.convertIdMapToEventList(person.getIds());
        this.setLayout((LayoutManager)new MigLayout("", "[][500lp:n,grow][]", "[][][][][][50lp:150lp][20lp]"));
        TmmLabel lblTypeT = new TmmLabel(TmmResourceBundle.getString("metatag.persontype"));
        this.add((Component)lblTypeT, "cell 0 0,alignx trailing");
        this.cbType = new JComboBox<Person.Type>(allowedTyes);
        this.add(this.cbType, "cell 1 0");
        TmmLabel lblNameT = new TmmLabel(TmmResourceBundle.getString("metatag.name"));
        this.add((Component)lblNameT, "cell 0 1,alignx trailing");
        this.tfName = new JTextField();
        this.add((Component)this.tfName, "cell 1 1,growx");
        this.tfName.setColumns(10);
        TmmLabel lblRoleT = new TmmLabel(TmmResourceBundle.getString("metatag.role"));
        this.add((Component)lblRoleT, "cell 0 2,alignx trailing");
        this.tfRole = new JTextField();
        this.add((Component)this.tfRole, "cell 1 2,growx");
        this.tfRole.setColumns(10);
        TmmLabel lblImageUrlT = new TmmLabel(TmmResourceBundle.getString("image.url"));
        this.add((Component)lblImageUrlT, "cell 0 3,alignx trailing");
        this.tfImageUrl = new JTextField();
        this.add((Component)this.tfImageUrl, "cell 1 3,growx");
        this.tfImageUrl.setColumns(10);
        JButton btnShowImage = new JButton(IconManager.IMAGE_INV);
        btnShowImage.setToolTipText(TmmResourceBundle.getString("image.show"));
        btnShowImage.addActionListener(e -> {
            if (StringUtils.isNotBlank((CharSequence)this.tfImageUrl.getText())) {
                try {
                    URL url = new URL(this.tfImageUrl.getText());
                    ImagePreviewDialog dialog = new ImagePreviewDialog(url.toExternalForm());
                    ((Dialog)dialog).setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.add((Component)btnShowImage, "cell 2 3");
        TmmLabel lblProfileUrlT = new TmmLabel(TmmResourceBundle.getString("profile.url"));
        this.add((Component)lblProfileUrlT, "cell 0 4,alignx trailing");
        this.tfProfileUrl = new JTextField();
        this.add((Component)this.tfProfileUrl, "cell 1 4,growx");
        this.tfProfileUrl.setColumns(10);
        TmmLabel lblIds = new TmmLabel(TmmResourceBundle.getString("metatag.ids"));
        this.add((Component)lblIds, "flowy,cell 0 5,alignx right,aligny top");
        JScrollPane scrollPaneIds = new JScrollPane();
        this.add((Component)scrollPaneIds, "cell 1 5,grow");
        this.tableIds = new MediaIdTable(this.ids);
        this.tableIds.configureScrollPane(scrollPaneIds);
        SquareIconButton btnAddId = new SquareIconButton(new AddIdAction());
        this.add((Component)btnAddId, "cell 0 5,alignx right,aligny top");
        SquareIconButton btnRemoveId = new SquareIconButton(new RemoveIdAction());
        this.add((Component)btnRemoveId, "cell 0 5,alignx right,aligny top");
        this.cbType.setSelectedItem((Object)person.getType());
        this.tfName.setText(person.getName());
        this.tfRole.setText(person.getRole());
        this.tfImageUrl.setText(person.getThumbUrl());
        this.tfProfileUrl.setText(person.getProfileUrl());
        SwingUtilities.invokeLater(this.tfName::requestFocus);
    }

    @Override
    protected void onClose() {
        this.person.setType((Person.Type)((Object)this.cbType.getSelectedItem()));
        this.person.setName(this.tfName.getText());
        this.person.setRole(this.tfRole.getText());
        this.person.setThumbUrl(this.tfImageUrl.getText());
        this.person.setProfileUrl(this.tfProfileUrl.getText());
        for (MediaIdTable.MediaId id : this.ids) {
            try {
                Integer value = Integer.parseInt(id.value);
                this.person.setId(id.key, value);
            }
            catch (NumberFormatException ex) {
                this.person.setId(id.key, id.value);
            }
        }
        ArrayList<String> removeIds = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.person.getIds().entrySet()) {
            MediaIdTable.MediaId id = new MediaIdTable.MediaId(entry.getKey());
            if (this.ids.contains((Object)id)) continue;
            removeIds.add(entry.getKey());
        }
        for (String id : removeIds) {
            this.person.setId(id, null);
        }
        this.setVisible(false);
    }

    private class AddIdAction
    extends AbstractAction {
        public AddIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(PersonEditorPanel.this);
            if (iModalPopupPanelProvider == null) {
                return;
            }
            MediaIdTable.MediaId mediaId = new MediaIdTable.MediaId();
            ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("id.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaId.key, mediaId.value})) {
                    PersonEditorPanel.this.ids.add((Object)mediaId);
                }
            });
            IdEditorPanel idEditorPanel = new IdEditorPanel(mediaId, null);
            popupPanel.setContent(idEditorPanel);
            iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        public RemoveIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmUIHelper.removeSelectedRowsFromJTable(PersonEditorPanel.this.tableIds, PersonEditorPanel.this.ids);
        }
    }
}

