/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieVideoContainerFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieVideoContainerFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallVideoContainerArray();
        EventBus.registerListener("movies-ui", event -> this.buildAndInstallVideoContainerArray());
    }

    @Override
    public String getId() {
        return "movieVideoContainer";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        String container = movie.getMediaInfoContainerFormat();
        for (String value : selectedValues) {
            if (!value.equalsIgnoreCase(container)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.container"));
    }

    private void buildAndInstallVideoContainerArray() {
        HashSet<String> videoContainersInMovies = new HashSet<String>(this.movieList.getVideoContainersInMovies());
        if (!SetUtils.equals(this.oldValues, videoContainersInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(videoContainersInMovies);
            List<String> sortedVideoContainers = ListUtils.asSortedList(videoContainersInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedVideoContainers));
        }
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

