/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieFrameRateFilter
extends AbstractCheckComboBoxMovieUIFilter<Double> {
    public MovieFrameRateFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith((String)s2));
        this.buildAndInstallFrameRateArray();
        EventBus.registerListener("movies-ui", event -> this.buildAndInstallFrameRateArray());
    }

    @Override
    public String getId() {
        return "movieFrameRate";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains(movie.getMediaInfoFrameRate());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.framerate"));
    }

    private void buildAndInstallFrameRateArray() {
        HashSet<Double> frameRatesInMovies = new HashSet<Double>(this.movieList.getFrameRatesInMovies());
        if (!SetUtils.equals(this.oldValues, frameRatesInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(frameRatesInMovies);
            List<Double> sortedFrameRates = ListUtils.asSortedList(frameRatesInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedFrameRates));
        }
    }

    @Override
    protected String parseTypeToString(Double type) throws Exception {
        return type.toString();
    }

    @Override
    protected Double parseStringToType(String string) throws Exception {
        return Double.parseDouble(string);
    }
}

