/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieAudioLanguageFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieAudioLanguageFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallAudioLanguageArray();
        EventBus.registerListener("movies-ui", event -> this.buildAndInstallAudioLanguageArray());
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.language"));
    }

    @Override
    public String getId() {
        return "movieAudioLanguage";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<MediaFile> mediaFileList = movie.getMediaFiles(MediaFileType.VIDEO);
        for (MediaFile mf : mediaFileList) {
            if (selectedItems.isEmpty() && mf.getAudioLanguagesList().isEmpty()) {
                return true;
            }
            for (String lang : mf.getAudioLanguagesList()) {
                if (!selectedItems.contains(lang)) continue;
                return true;
            }
        }
        return false;
    }

    private void buildAndInstallAudioLanguageArray() {
        HashSet<String> audioLanguagesInMovies = new HashSet<String>(this.movieList.getAudioLanguagesInMovies());
        if (!SetUtils.equals(this.oldValues, audioLanguagesInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(audioLanguagesInMovies);
            List<String> sortedAudioLanguages = ListUtils.asSortedList(audioLanguagesInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedAudioLanguages));
        }
    }
}

