/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import com.sun.jna.WString;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.tinymediamanager.thirdparty.TinyFileDialogsLibrary;

public class TinyFileDialogs {
    public Path chooseDirectory(String title, Path defaultPath) throws Exception {
        if (TinyFileDialogsLibrary.INSTANCE == null) {
            throw new Exception("Could not access tinyfiledialogs");
        }
        Object initialPath = null;
        if (defaultPath != null) {
            initialPath = defaultPath.toAbsolutePath().toString();
            if (defaultPath.toFile().isDirectory()) {
                initialPath = (String)initialPath + File.separator;
            }
        }
        String path = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            WString initialPathW;
            WString titleW = title != null ? new WString(title) : null;
            WString result = TinyFileDialogsLibrary.INSTANCE.tinyfd_selectFolderDialogW(titleW, initialPathW = initialPath != null ? new WString((String)initialPath) : null);
            if (result != null) {
                path = result.toString();
            }
        } else {
            path = TinyFileDialogsLibrary.INSTANCE.tinyfd_selectFolderDialog(title, (String)initialPath);
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        return Paths.get(path, new String[0]);
    }

    public Path openFile(String title, Path defaultFile, String[] filterPatterns, String singleFilterDescription) throws Exception {
        if (TinyFileDialogsLibrary.INSTANCE == null) {
            throw new Exception("Could not access tinyfiledialogs");
        }
        Object initialFile = null;
        if (defaultFile != null) {
            initialFile = defaultFile.toAbsolutePath().toString();
            if (defaultFile.toFile().isDirectory()) {
                initialFile = (String)initialFile + File.separator;
            }
        }
        int filterPatternCount = 0;
        if (filterPatterns != null) {
            filterPatternCount = filterPatterns.length;
        }
        String path = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            WString result;
            WString titleW = title != null ? new WString(title) : null;
            WString initialFileW = initialFile != null ? new WString((String)initialFile) : null;
            WString singleFilterDescriptionW = singleFilterDescription != null ? new WString(singleFilterDescription) : null;
            WString[] filterPatternsW = null;
            if (filterPatterns != null) {
                filterPatternsW = new WString[filterPatterns.length];
                for (int i = 0; i < filterPatterns.length; ++i) {
                    filterPatternsW[i] = new WString(filterPatterns[i]);
                }
            }
            if ((result = TinyFileDialogsLibrary.INSTANCE.tinyfd_openFileDialogW(titleW, initialFileW, filterPatternCount, filterPatternsW, singleFilterDescriptionW, 0)) != null) {
                path = result.toString();
            }
        } else {
            path = TinyFileDialogsLibrary.INSTANCE.tinyfd_openFileDialog(title, (String)initialFile, filterPatternCount, filterPatterns, singleFilterDescription, 0);
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        return Paths.get(path, new String[0]);
    }

    public Path saveFile(String title, Path defaultFile, String[] filterPatterns, String singleFilterDescription) throws Exception {
        if (TinyFileDialogsLibrary.INSTANCE == null) {
            throw new Exception("Could not access tinyfiledialogs");
        }
        String initialFile = defaultFile != null ? defaultFile.toAbsolutePath().toString() : null;
        int filterPatternCount = 0;
        if (filterPatterns != null) {
            filterPatternCount = filterPatterns.length;
        }
        String path = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            WString result;
            WString titleW = title != null ? new WString(title) : null;
            WString initialFileW = initialFile != null ? new WString(initialFile) : null;
            WString singleFilterDescriptionW = singleFilterDescription != null ? new WString(singleFilterDescription) : null;
            WString[] filterPatternsW = null;
            if (filterPatterns != null) {
                filterPatternsW = new WString[filterPatterns.length];
                for (int i = 0; i < filterPatterns.length; ++i) {
                    filterPatternsW[i] = new WString(filterPatterns[i]);
                }
            }
            if ((result = TinyFileDialogsLibrary.INSTANCE.tinyfd_saveFileDialogW(titleW, initialFileW, filterPatternCount, filterPatternsW, singleFilterDescriptionW)) != null) {
                path = result.toString();
            }
        } else {
            path = TinyFileDialogsLibrary.INSTANCE.tinyfd_saveFileDialog(title, initialFile, filterPatternCount, filterPatterns, singleFilterDescription);
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        return Paths.get(path, new String[0]);
    }
}

