/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.fanarttv;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.fanarttv.FanartTv;
import org.tinymediamanager.scraper.fanarttv.entities.Image;
import org.tinymediamanager.scraper.fanarttv.entities.Images;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.util.ListUtils;

abstract class FanartTvMetadataProvider
implements IMediaProvider {
    static final String ID = "fanarttv";
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected FanartTv api = null;

    FanartTvMetadataProvider() {
    }

    protected abstract String getSubId();

    private MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo(ID, this.getSubId(), "fanart.tv", "<html><h3>Fanart.tv</h3><br />Fanart.tv provides a huge library of artwork for movies, TV shows and music. This service can be consumed with the API key tinyMediaManager offers, but if you want to have faster access to the artwork, you should become a VIP at fanart.tv (https://fanart.tv/vip/).</html>", FanartTvMetadataProvider.class.getResource("/org/tinymediamanager/scraper/fanart_tv.png"));
        info.getConfig().addText("clientKey", "", true);
        info.getConfig().load();
        return info;
    }

    protected synchronized void initAPI() throws ScrapeException {
        if (this.api == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                this.api = new FanartTv();
            }
            catch (Exception e) {
                this.getLogger().error("FanartTvMetadataProvider", (Throwable)e);
                throw new ScrapeException(e);
            }
        }
        try {
            this.api.setApiKey(this.getApiKey());
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
        String clientKey = this.providerInfo.getConfig().getValue("clientKey");
        if (!clientKey.equals(this.api.getClientKey())) {
            this.api.setClientKey(clientKey);
        }
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(null);
    }

    abstract Logger getLogger();

    protected List<MediaArtwork> getArtwork(Images images, MediaArtwork.MediaArtworkType artworkType) {
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        switch (artworkType) {
            case POSTER: {
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEPOSTER));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVPOSTER));
                break;
            }
            case BACKGROUND: {
                artworks.addAll(this.prepareArtwork(images.moviebackground, ImageType.MOVIEBACKGROUND));
                artworks.addAll(this.prepareArtwork(images.showbackground, ImageType.SHOWBACKGROUND));
                break;
            }
            case BANNER: {
                artworks.addAll(this.prepareArtwork(images.moviebanner, ImageType.MOVIEBANNER));
                artworks.addAll(this.prepareArtwork(images.tvbanner, ImageType.TVBANNER));
                break;
            }
            case CLEARART: {
                artworks.addAll(this.prepareArtwork(images.hdmovieclearart, ImageType.HDMOVIECLEARART));
                artworks.addAll(this.prepareArtwork(images.hdclearart, ImageType.HDCLEARART));
                break;
            }
            case DISC: {
                artworks.addAll(this.prepareArtwork(images.moviedisc, ImageType.MOVIEDISC));
                break;
            }
            case LOGO: 
            case CLEARLOGO: {
                artworks.addAll(this.prepareArtwork(images.hdmovielogo, ImageType.HDMOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.hdtvlogo, ImageType.HDTVLOGO));
                break;
            }
            case SEASON_POSTER: {
                artworks.addAll(this.prepareArtwork(images.seasonposter, ImageType.SEASONPOSTER));
                break;
            }
            case SEASON_BANNER: {
                artworks.addAll(this.prepareArtwork(images.seasonbanner, ImageType.SEASONBANNER));
                break;
            }
            case SEASON_THUMB: {
                artworks.addAll(this.prepareArtwork(images.seasonthumb, ImageType.SEASONTHUMB));
                break;
            }
            case THUMB: {
                artworks.addAll(this.prepareArtwork(images.moviethumb, ImageType.MOVIETHUMB));
                artworks.addAll(this.prepareArtwork(images.tvthumb, ImageType.TVTHUMB));
                break;
            }
            case CHARACTERART: {
                artworks.addAll(this.prepareArtwork(images.characterart, ImageType.CHARACTERART));
                break;
            }
            case KEYART: {
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEKEYART));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVKEYART));
                break;
            }
            case ALL: {
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEPOSTER));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVPOSTER));
                artworks.addAll(this.prepareArtwork(images.moviebackground, ImageType.MOVIEBACKGROUND));
                artworks.addAll(this.prepareArtwork(images.showbackground, ImageType.SHOWBACKGROUND));
                artworks.addAll(this.prepareArtwork(images.moviebanner, ImageType.MOVIEBANNER));
                artworks.addAll(this.prepareArtwork(images.tvbanner, ImageType.TVBANNER));
                artworks.addAll(this.prepareArtwork(images.hdmovieclearart, ImageType.HDMOVIECLEARART));
                artworks.addAll(this.prepareArtwork(images.hdclearart, ImageType.HDCLEARART));
                artworks.addAll(this.prepareArtwork(images.moviedisc, ImageType.MOVIEDISC));
                artworks.addAll(this.prepareArtwork(images.hdmovielogo, ImageType.HDMOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.hdtvlogo, ImageType.HDTVLOGO));
                artworks.addAll(this.prepareArtwork(images.seasonbanner, ImageType.SEASONBANNER));
                artworks.addAll(this.prepareArtwork(images.seasonposter, ImageType.SEASONPOSTER));
                artworks.addAll(this.prepareArtwork(images.seasonthumb, ImageType.SEASONTHUMB));
                artworks.addAll(this.prepareArtwork(images.moviethumb, ImageType.MOVIETHUMB));
                artworks.addAll(this.prepareArtwork(images.tvthumb, ImageType.TVTHUMB));
                artworks.addAll(this.prepareArtwork(images.characterart, ImageType.CHARACTERART));
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEKEYART));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVKEYART));
                break;
            }
        }
        return artworks;
    }

    protected List<MediaArtwork> prepareArtwork(List<Image> images, ImageType type) {
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        for (Image image : ListUtils.nullSafe(images)) {
            if ((type == ImageType.MOVIEKEYART || type == ImageType.TVKEYART) && !"00".equals(image.lang)) continue;
            MediaArtwork ma = new MediaArtwork(this.providerInfo.getId(), type.type);
            ma.setOriginalUrl(image.url);
            ma.setPreviewUrl(image.url.replace("/fanart/", "/preview/"));
            if ("00".equals(image.lang) || StringUtils.isBlank((CharSequence)image.lang)) {
                ma.setLanguage("");
            } else {
                ma.setLanguage(image.lang);
            }
            ma.setLikes(image.likes);
            if (image.width > 0 && image.height > 0) {
                ma.addImageSize(image.width, image.height, image.url, type.sizeOrder);
            } else {
                ma.addImageSize(type.width, type.height, image.url, type.sizeOrder);
            }
            if ("all".equals(image.season)) {
                ma.setSeason(0);
            } else if (StringUtils.isNotBlank((CharSequence)image.season)) {
                try {
                    ma.setSeason(Integer.parseInt(image.season));
                }
                catch (Exception e) {
                    this.getLogger().trace("could not parse int: {}", (Object)e.getMessage());
                }
            }
            artworks.add(ma);
        }
        return artworks;
    }

    private static enum ImageType {
        CHARACTERART(512, 512, MediaArtwork.MediaArtworkType.CHARACTERART, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDCLEARART(1000, 562, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDMOVIECLEARART(1000, 562, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDMOVIELOGO(800, 310, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDTVLOGO(800, 310, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        MOVIEBACKGROUND(1920, 1080, MediaArtwork.MediaArtworkType.BACKGROUND, MediaArtwork.FanartSizes.LARGE.getOrder()),
        MOVIEBANNER(1000, 185, MediaArtwork.MediaArtworkType.BANNER, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        MOVIEDISC(1000, 1000, MediaArtwork.MediaArtworkType.DISC, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        MOVIEKEYART(1000, 1426, MediaArtwork.MediaArtworkType.KEYART, MediaArtwork.PosterSizes.LARGE.getOrder()),
        MOVIEPOSTER(1000, 1426, MediaArtwork.MediaArtworkType.POSTER, MediaArtwork.PosterSizes.LARGE.getOrder()),
        MOVIETHUMB(1000, 562, MediaArtwork.MediaArtworkType.THUMB, MediaArtwork.ThumbSizes.BIG.getOrder()),
        SEASONBANNER(1000, 185, MediaArtwork.MediaArtworkType.SEASON_BANNER, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        SEASONPOSTER(1000, 1426, MediaArtwork.MediaArtworkType.SEASON_POSTER, MediaArtwork.PosterSizes.LARGE.getOrder()),
        SEASONTHUMB(1000, 562, MediaArtwork.MediaArtworkType.SEASON_THUMB, MediaArtwork.ThumbSizes.BIG.getOrder()),
        SHOWBACKGROUND(1920, 1080, MediaArtwork.MediaArtworkType.BACKGROUND, MediaArtwork.FanartSizes.LARGE.getOrder()),
        TVBANNER(1000, 185, MediaArtwork.MediaArtworkType.BANNER, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        TVKEYART(1000, 1426, MediaArtwork.MediaArtworkType.KEYART, MediaArtwork.PosterSizes.LARGE.getOrder()),
        TVPOSTER(1000, 1426, MediaArtwork.MediaArtworkType.POSTER, MediaArtwork.PosterSizes.LARGE.getOrder()),
        TVTHUMB(1000, 562, MediaArtwork.MediaArtworkType.THUMB, MediaArtwork.ThumbSizes.BIG.getOrder());

        final int width;
        final int height;
        final MediaArtwork.MediaArtworkType type;
        final int sizeOrder;

        private ImageType(int width, int height, MediaArtwork.MediaArtworkType type, int sizeOrder) {
            this.width = width;
            this.height = height;
            this.type = type;
            this.sizeOrder = sizeOrder;
        }
    }
}

