/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.HexStringIntegerAdapter;
import org.tinymediamanager.library.bluray.playlist.UnsignedIntHelper;

public class Mark {
    private int id;
    private int type;
    private int playItemIdRef;
    private long markTimeStamp;
    private int entryEsPid;
    private long duration;

    public Mark() {
    }

    public Mark(int n) {
        this.id = n;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        dataInputStream.skipBytes(1);
        this.setType(dataInputStream.readUnsignedByte());
        this.setPlayItemIdRef(dataInputStream.readUnsignedShort());
        dataInputStream.readFully(byArray);
        this.setMarkTimeStamp(UnsignedIntHelper.convertToLong(byArray));
        this.setEntryEsPid(dataInputStream.readUnsignedShort());
        dataInputStream.readFully(byArray2);
        this.setDuration(UnsignedIntHelper.convertToLong(byArray2));
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(this.getType());
        dataOutputStream.writeShort(this.getPlayItemIdRef());
        dataOutputStream.write(UnsignedIntHelper.convertToBytes(this.getMarkTimeStamp()));
        dataOutputStream.writeShort(this.getEntryEsPid());
        dataOutputStream.write(UnsignedIntHelper.convertToBytes(this.getDuration()));
    }

    @XmlAttribute
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Unexpected type " + n);
        }
        this.type = n;
    }

    public int getPlayItemIdRef() {
        return this.playItemIdRef;
    }

    public void setPlayItemIdRef(int n) {
        this.playItemIdRef = n;
    }

    public long getMarkTimeStamp() {
        return this.markTimeStamp;
    }

    public void setMarkTimeStamp(long l) {
        this.markTimeStamp = l;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getEntryEsPid() {
        return this.entryEsPid;
    }

    public void setEntryEsPid(Integer n) {
        this.entryEsPid = n;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }
}

