/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowVideoCodecFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowVideoCodecFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallVideoCodecArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallVideoCodecArray());
    }

    @Override
    public String getId() {
        return "tvShowVideoCodec";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List codecs = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
            for (MediaFile mf : mfs) {
                if (!(invert ^ codecs.contains(mf.getVideoCodec()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.videocodec"));
    }

    private void buildAndInstallVideoCodecArray() {
        HashSet<String> videoCodecsInEpisodes = new HashSet<String>(this.tvShowList.getVideoCodecsInEpisodes());
        if (!SetUtils.equals(this.oldValues, videoCodecsInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(videoCodecsInEpisodes);
            List<String> sortedVideoCodecs = ListUtils.asSortedList(videoCodecsInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedVideoCodecs));
        }
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

