/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.Collections;

interface MediaInfoLibrary
extends Library {
    public static final MediaInfoLibrary INSTANCE = MediaInfoLibrary.load();

    private static MediaInfoLibrary load() {
        try {
            if (Platform.isLinux()) {
                Native.load((String)"zen", Library.class);
            }
            return (MediaInfoLibrary)Native.load((String)"mediainfo", MediaInfoLibrary.class, Collections.singletonMap("function-mapper", (lib, method) -> "MediaInfo_" + method.getName()));
        }
        catch (UnsatisfiedLinkError e) {
            return null;
        }
    }

    public Pointer New();

    public void Delete(Pointer var1);

    public SizeT Open(Pointer var1, WString var2);

    public SizeT Open_Buffer_Init(Pointer var1, long var2, long var4);

    public SizeT Open_Buffer_Continue(Pointer var1, byte[] var2, SizeT var3);

    public long Open_Buffer_Continue_GoTo_Get(Pointer var1);

    public SizeT Open_Buffer_Finalize(Pointer var1);

    public void Close(Pointer var1);

    public WString Inform(Pointer var1, int var2);

    public WString Get(Pointer var1, int var2, SizeT var3, WString var4, int var5, int var6);

    public WString GetI(Pointer var1, int var2, SizeT var3, SizeT var4, int var5);

    public SizeT Count_Get(Pointer var1, int var2, SizeT var3);

    public WString Option(Pointer var1, WString var2, WString var3);

    public static class SizeT
    extends IntegerType {
        public SizeT() {
            super(Native.SIZE_T_SIZE, 0L, true);
        }

        public SizeT(long value) {
            super(Native.SIZE_T_SIZE, value, true);
        }
    }
}

