/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.universal_tvshow;

import com.google.gson.Gson;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.config.MediaProviderConfig;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTmdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTvdbMetadataProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public class UniversalTvShowMetadataProvider
implements ITvShowMetadataProvider {
    public static final String ID = "universal_tvshow";
    private static final String UNDEFINED = "-";
    private static final String SEARCH = "search";
    private static final String RATINGS = "ratings";
    private static final String FALLBACK_SCRAPERS = "fallbackScrapers";
    private static final Logger LOGGER = LoggerFactory.getLogger(UniversalTvShowMetadataProvider.class);
    private static final Map<String, ITvShowMetadataProvider> COMPATIBLE_SCRAPERS = new LinkedHashMap<String, ITvShowMetadataProvider>();
    private static final ExecutorService EXECUTOR = new ThreadPoolExecutor(4, 8, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    public UniversalTvShowMetadataProvider() {
        this.init();
    }

    private MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, ID, "Universal TV show scraper", "<html><h3>Universal TV show scraper</h3><br />A meta scraper which allows to collect data from several other scrapers</html>", UniversalTvShowMetadataProvider.class.getResource("/org/tinymediamanager/scraper/tmm_logo.svg"));
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled();
    }

    public static void addProvider(ITvShowMetadataProvider provider) {
        if (!provider.getId().equals(ID) && !COMPATIBLE_SCRAPERS.containsKey(provider.getId()) && (provider instanceof ITvShowTvdbMetadataProvider || provider instanceof ITvShowImdbMetadataProvider) || provider instanceof ITvShowTmdbMetadataProvider) {
            COMPATIBLE_SCRAPERS.put(provider.getId(), provider);
        }
    }

    private void init() {
        MediaProviderConfig config = this.providerInfo.getConfig();
        ArrayList<String> compatibleScraperIds = new ArrayList<String>(COMPATIBLE_SCRAPERS.keySet());
        compatibleScraperIds.add(0, UNDEFINED);
        config.addLabel("searchLabel", "Button.search");
        config.addSelect(SEARCH, compatibleScraperIds, UNDEFINED);
        config.addLabel("tvShowLabel", "tmm.tvshow");
        config.addSelect("title", "metatag.title", compatibleScraperIds, UNDEFINED);
        config.addSelect("originalTitle", "metatag.originaltitle", compatibleScraperIds, UNDEFINED);
        config.addSelect("englishTitle", "metatag.title.english", this.only("tmdb", "imdb"), UNDEFINED);
        config.addSelect("tagline", "metatag.tagline", this.only("tmdb"), UNDEFINED);
        config.addSelect("year", "metatag.year", compatibleScraperIds, UNDEFINED);
        config.addSelect("releaseDate", "metatag.releasedate", compatibleScraperIds, UNDEFINED);
        config.addSelect("plot", "metatag.plot", compatibleScraperIds, UNDEFINED);
        config.addSelect("runtime", "metatag.runtime", compatibleScraperIds, UNDEFINED);
        config.addSelect(RATINGS, "metatag.rating", this.scrapersWithout(compatibleScraperIds, "tvdb"), UNDEFINED);
        config.addSelect("genres", "metatag.genre", compatibleScraperIds, UNDEFINED);
        config.addSelect("certifications", "metatag.certification", compatibleScraperIds, UNDEFINED);
        config.addSelect("productionCompanies", "metatag.studio", compatibleScraperIds, UNDEFINED);
        config.addSelect("castMembers", "metatag.cast", compatibleScraperIds, UNDEFINED);
        config.addSelect("spokenLanguages", "metatag.spokenlanguages", compatibleScraperIds, UNDEFINED);
        config.addSelect("countries", "metatag.country", compatibleScraperIds, UNDEFINED);
        config.addSelect("tags", "metatag.tags", compatibleScraperIds, UNDEFINED);
        config.addSelect("status", "metatag.status", compatibleScraperIds, UNDEFINED);
        config.addLabel("seasonLabel", "metatag.season");
        config.addSelect("seasonNames", "metatag.seasonname", this.only("tvdb", "tmdb"), UNDEFINED);
        config.addSelect("seasonOverview", "metatag.seasonoverview", this.only("tvdb", "tmdb"), UNDEFINED);
        config.addLabel("episodeLabel", "metatag.episode");
        config.addSelect("episodes", "metatag.episodes", compatibleScraperIds, UNDEFINED);
        config.addSelect("episodeTitle", "metatag.title", compatibleScraperIds, UNDEFINED);
        config.addSelect("episodeOriginalTitle", "metatag.originaltitle", compatibleScraperIds, UNDEFINED);
        config.addSelect("episodeEnglishTitle", "metatag.title.english", compatibleScraperIds, UNDEFINED);
        config.addSelect("episodePlot", "metatag.plot", compatibleScraperIds, UNDEFINED);
        config.addSelect("episodeCastMembers", "metatag.cast", compatibleScraperIds, UNDEFINED);
        config.addSelect("episodeRatings", "metatag.rating", this.scrapersWithout(compatibleScraperIds, "tvdb"), UNDEFINED);
        config.addLabel("fallbackLabel", "scraper.universal_tvshow.scraperstouse");
        config.addMultiSelect(FALLBACK_SCRAPERS, "scraper.universal_tvshow.scrapers", this.scrapersWithout(compatibleScraperIds, UNDEFINED), new String[0]);
        config.load();
    }

    private List<String> scrapersWithout(List<String> scrapers, String ... excludes) {
        ArrayList<String> newScrapers = new ArrayList<String>(scrapers);
        for (String scraperToExclude : excludes) {
            newScrapers.remove(scraperToExclude);
        }
        return newScrapers;
    }

    private List<String> only(String ... includes) {
        ArrayList<String> newScrapers = new ArrayList<String>();
        newScrapers.add(UNDEFINED);
        Collections.addAll(newScrapers, includes);
        return newScrapers;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public SortedSet<MediaSearchResult> search(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        ITvShowMetadataProvider mp = COMPATIBLE_SCRAPERS.get(this.providerInfo.getConfig().getValue(SEARCH));
        if (mp == null) {
            return results;
        }
        try {
            for (MediaSearchResult result : mp.search(options)) {
                result.setId(this.providerInfo.getId(), result.getIdAsString(result.getProviderId()));
                result.setProviderId(this.providerInfo.getId());
                results.add(result);
            }
        }
        catch (ScrapeException e) {
            LOGGER.debug("Could not call search method of {} - {}", (Object)mp.getProviderInfo().getId(), (Object)e.getMessage());
            throw e;
        }
        return results;
    }

    private Set<ITvShowMetadataProvider> getRelevantMetadataProviders(boolean episode) {
        HashSet<ITvShowMetadataProvider> metadataProviders = new HashSet<ITvShowMetadataProvider>();
        for (Map.Entry<String, String> entry : this.providerInfo.getConfig().getConfigKeyValuePairs().entrySet()) {
            List<String> values = FALLBACK_SCRAPERS.equals(entry.getKey()) ? Arrays.asList((String[])new Gson().fromJson(entry.getValue(), String[].class)) : Collections.singletonList(entry.getValue());
            for (String value : values) {
                ITvShowMetadataProvider mp;
                if (!(episode && entry.getKey().startsWith("episode") || !episode && !entry.getKey().startsWith("episode")) && !FALLBACK_SCRAPERS.equals(entry.getKey()) || UNDEFINED.equals(value) || (mp = COMPATIBLE_SCRAPERS.get(value)) == null || !mp.isActive()) continue;
                metadataProviders.add(mp);
            }
        }
        return metadataProviders;
    }

    private Map<String, MediaMetadata> getTvShowMetadataMap(Set<ITvShowMetadataProvider> metadataProviders, TvShowSearchAndScrapeOptions options) {
        Map<String, MediaMetadata> metadataMap = this.injectMissingIds(metadataProviders, options);
        ExecutorCompletionService<MediaMetadata> completionService = new ExecutorCompletionService<MediaMetadata>(EXECUTOR);
        ArrayList<Future<MediaMetadata>> futures = new ArrayList<Future<MediaMetadata>>();
        for (ITvShowMetadataProvider iTvShowMetadataProvider : metadataProviders) {
            if (metadataMap.get(iTvShowMetadataProvider.getProviderInfo().getId()) != null || !iTvShowMetadataProvider.isActive()) continue;
            futures.add(completionService.submit(new TvShowMetadataProviderWorker(iTvShowMetadataProvider, options)));
        }
        for (Future future : futures) {
            try {
                MediaMetadata mediaMetadata = (MediaMetadata)future.get();
                if (mediaMetadata == null) continue;
                metadataMap.put(mediaMetadata.getProviderId(), mediaMetadata);
            }
            catch (Exception e) {
                LOGGER.debug("Could not get a result from scraper: {}", (Object)e.getMessage());
            }
        }
        return metadataMap;
    }

    private Map<String, MediaMetadata> getTvShowEpisodeMetadataMap(Set<ITvShowMetadataProvider> metadataProviders, TvShowEpisodeSearchAndScrapeOptions options) {
        TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = options.createTvShowSearchAndScrapeOptions();
        this.injectMissingIds(metadataProviders, tvShowSearchAndScrapeOptions);
        for (Map.Entry<String, Object> entry : tvShowSearchAndScrapeOptions.getIds().entrySet()) {
            if (options.getTvShowIds().containsKey(entry.getKey())) continue;
            options.getTvShowIds().put(entry.getKey(), entry.getValue());
        }
        Map<String, MediaMetadata> metadataMap = this.injectMissingIds(metadataProviders, options);
        ExecutorCompletionService<MediaMetadata> completionService = new ExecutorCompletionService<MediaMetadata>(EXECUTOR);
        ArrayList<Future<MediaMetadata>> futures = new ArrayList<Future<MediaMetadata>>();
        for (ITvShowMetadataProvider iTvShowMetadataProvider : metadataProviders) {
            if (metadataMap.get(iTvShowMetadataProvider.getProviderInfo().getId()) != null || !iTvShowMetadataProvider.isActive()) continue;
            futures.add(completionService.submit(new TvShowEpisodeMetadataProviderWorker(iTvShowMetadataProvider, options)));
        }
        for (Future future : futures) {
            try {
                MediaMetadata mediaMetadata = (MediaMetadata)future.get();
                if (mediaMetadata == null) continue;
                metadataMap.put(mediaMetadata.getProviderId(), mediaMetadata);
            }
            catch (Exception e) {
                LOGGER.debug("Could not get a result from scraper: {}", (Object)e.getMessage());
            }
        }
        return metadataMap;
    }

    private Map<String, MediaMetadata> injectMissingIds(Set<ITvShowMetadataProvider> metadataProviders, TvShowSearchAndScrapeOptions options) {
        String imdbId = options.getImdbId();
        int tmdbId = options.getTmdbId();
        int tvdbId = options.getIdAsInt("tvdb");
        HashMap<String, MediaMetadata> metadataMap = new HashMap<String, MediaMetadata>();
        for (ITvShowMetadataProvider mp : metadataProviders) {
            Object id;
            if (mp instanceof ITvShowImdbMetadataProvider && MediaIdUtil.isValidImdbId(imdbId) || mp instanceof ITvShowTmdbMetadataProvider && tmdbId > 0 || mp instanceof ITvShowTvdbMetadataProvider && tvdbId > 0 || tmdbId <= 0 && !MediaIdUtil.isValidImdbId(imdbId) && tvdbId <= 0) continue;
            MediaMetadata md = (MediaMetadata)metadataMap.get("tmdb");
            if (md == null) {
                try {
                    ITvShowMetadataProvider tmdb = COMPATIBLE_SCRAPERS.get("tmdb");
                    if (tmdb != null && (md = tmdb.getMetadata(options)) != null) {
                        metadataMap.put("tmdb", md);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Could not get a result from scraper: {}", (Object)e.getMessage());
                }
            }
            if (md == null) continue;
            if (tmdbId == 0 && (id = md.getId("tmdb")) != null) {
                try {
                    tmdbId = id instanceof Integer ? (Integer)id : Integer.parseInt(id.toString());
                }
                catch (Exception ignored) {
                    LOGGER.trace("could not parse tmdb id: - {}", md.getId("tmdb"));
                }
            }
            if (!MediaIdUtil.isValidImdbId(imdbId) && MediaIdUtil.isValidImdbId((String)md.getId("imdb"))) {
                imdbId = (String)md.getId("imdb");
            }
            if (tvdbId != 0 || (id = md.getId("tvdb")) == null) break;
            try {
                if (id instanceof Integer) {
                    tvdbId = (Integer)id;
                    break;
                }
                tvdbId = Integer.parseInt(id.toString());
            }
            catch (Exception ignored) {
                LOGGER.trace("could not parse tvdb id: - {}", md.getId("tvdb"));
            }
            break;
        }
        if (MediaIdUtil.isValidImdbId(imdbId)) {
            options.setImdbId(imdbId);
        }
        if (tmdbId > 0) {
            options.setTmdbId(tmdbId);
        }
        if (tvdbId > 0) {
            options.setId("tvdb", String.valueOf(tvdbId));
        }
        return metadataMap;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata() - {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        MediaMetadata md = new MediaMetadata(this.providerInfo.getId());
        md.setScrapeOptions(options);
        Set<ITvShowMetadataProvider> metadataProviders = this.getRelevantMetadataProviders(false);
        if (metadataProviders.isEmpty()) {
            return md;
        }
        Map<String, MediaMetadata> metadataMap = this.getTvShowMetadataMap(metadataProviders, options);
        this.assignTvShowResults(md, metadataMap);
        if (md.getIds().isEmpty()) {
            throw new NothingFoundException();
        }
        return md;
    }

    private void assignTvShowResults(MediaMetadata md, Map<String, MediaMetadata> metadataMap) {
        for (Map.Entry<String, MediaMetadata> entry : metadataMap.entrySet()) {
            for (Map.Entry<String, Object> id : entry.getValue().getIds().entrySet()) {
                md.setId(id.getKey(), id.getValue());
            }
        }
        List<String> fallbackScrapers = Arrays.asList((String[])new Gson().fromJson(this.providerInfo.getConfig().getValue(FALLBACK_SCRAPERS), String[].class));
        for (Map.Entry<String, String> entry : this.providerInfo.getConfig().getConfigKeyValuePairs().entrySet()) {
            if (entry.getKey().startsWith("episode") || SEARCH.equals(entry.getKey()) || FALLBACK_SCRAPERS.equals(entry.getKey()) || UNDEFINED.equals(entry.getValue())) continue;
            ArrayList<String> scrapers = new ArrayList<String>(fallbackScrapers);
            scrapers.remove(entry.getValue());
            scrapers.add(0, entry.getValue());
            this.assignTvShowValue(scrapers, md, metadataMap, entry.getKey());
        }
        String string = this.providerInfo.getConfig().getValue("episodes");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.assignTvShowValue(Collections.singletonList(string), md, metadataMap, "episodeGroups");
        }
    }

    private void assignTvShowValue(List<String> scrapers, MediaMetadata md, Map<String, MediaMetadata> metadataMap, String field) {
        for (String scraper : scrapers) {
            MediaMetadata mediaMetadata = metadataMap.get(scraper);
            if (mediaMetadata == null) continue;
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field, MediaMetadata.class);
                Method getter = propertyDescriptor.getReadMethod();
                Method setter = propertyDescriptor.getWriteMethod();
                Object value = getter.invoke((Object)mediaMetadata, new Object[0]);
                if (!this.isValueFilled(value)) continue;
                setter.invoke((Object)md, value);
                return;
            }
            catch (Exception e) {
                LOGGER.debug("Problem assigning {} - {}", (Object)scraper, (Object)e.getMessage());
            }
        }
    }

    private boolean isValueFilled(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String string = (String)value;
            return StringUtils.isNotBlank((CharSequence)string);
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer != 0;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.floatValue() != 0.0f;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        if (value instanceof Date) {
            return true;
        }
        if (value instanceof MediaAiredStatus) {
            return value != MediaAiredStatus.UNKNOWN;
        }
        return false;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata() - {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        MediaMetadata md = new MediaMetadata(this.providerInfo.getId());
        md.setScrapeOptions(options);
        Set<ITvShowMetadataProvider> metadataProviders = this.getRelevantMetadataProviders(true);
        if (metadataProviders.isEmpty()) {
            return md;
        }
        Map<String, MediaMetadata> metadataMap = this.getTvShowEpisodeMetadataMap(metadataProviders, options);
        this.assignEpisodeResults(md, metadataMap);
        return md;
    }

    private void assignEpisodeResults(MediaMetadata md, Map<String, MediaMetadata> metadataMap) {
        for (Map.Entry<String, MediaMetadata> entry : metadataMap.entrySet()) {
            for (Map.Entry<String, Object> id : entry.getValue().getIds().entrySet()) {
                md.setId(id.getKey(), id.getValue());
            }
        }
        List<String> fallbackScrapers = Arrays.asList((String[])new Gson().fromJson(this.providerInfo.getConfig().getValue(FALLBACK_SCRAPERS), String[].class));
        for (Map.Entry<String, String> entry : this.providerInfo.getConfig().getConfigKeyValuePairs().entrySet()) {
            if (!entry.getKey().startsWith("episode") || UNDEFINED.equals(entry.getValue())) continue;
            if ("episodes".equals(entry.getKey())) {
                MediaMetadata mediaMetadata = metadataMap.get(entry.getValue());
                if (mediaMetadata == null) continue;
                md.setEpisodeNumbers(mediaMetadata.getEpisodeNumbers());
                md.setReleaseDate(mediaMetadata.getReleaseDate());
                continue;
            }
            ArrayList<String> scrapers = new ArrayList<String>(fallbackScrapers);
            scrapers.remove(entry.getValue());
            scrapers.add(0, entry.getValue());
            this.assignEpisodeValue(scrapers, md, metadataMap, entry.getKey());
        }
    }

    private void assignEpisodeValue(List<String> scrapers, MediaMetadata md, Map<String, MediaMetadata> metadataMap, String field) {
        for (String scraper : scrapers) {
            MediaMetadata mediaMetadata = metadataMap.get(scraper);
            if (mediaMetadata == null) continue;
            try {
                String episodeField = Introspector.decapitalize(field.replace("episode", ""));
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(episodeField, MediaMetadata.class);
                Method getter = propertyDescriptor.getReadMethod();
                Method setter = propertyDescriptor.getWriteMethod();
                Object value = getter.invoke((Object)mediaMetadata, new Object[0]);
                if (!this.isValueFilled(value)) continue;
                setter.invoke((Object)md, value);
                return;
            }
            catch (Exception e) {
                LOGGER.debug("Problem assigning {} - {}", (Object)scraper, (Object)e.getMessage());
            }
        }
    }

    @Override
    public List<MediaMetadata> getEpisodeList(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeList() - {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        ArrayList<MediaMetadata> episodeList = new ArrayList<MediaMetadata>();
        ITvShowMetadataProvider metadataProvider = COMPATIBLE_SCRAPERS.get(this.providerInfo.getConfig().getConfigKeyValuePairs().get("episodes"));
        if (metadataProvider != null) {
            this.injectMissingIds(Collections.singleton(metadataProvider), options);
            episodeList.addAll(metadataProvider.getEpisodeList(options));
        }
        return episodeList;
    }

    private Map<String, MediaMetadata> injectMissingIds(Set<ITvShowMetadataProvider> metadataProviders, TvShowEpisodeSearchAndScrapeOptions options) {
        String imdbId = options.getImdbId();
        int tmdbId = options.getTmdbId();
        int tvdbId = options.getIdAsInt("tvdb");
        HashMap<String, MediaMetadata> metadataMap = new HashMap<String, MediaMetadata>();
        for (ITvShowMetadataProvider mp : metadataProviders) {
            Object id;
            if (mp instanceof ITvShowImdbMetadataProvider && MediaIdUtil.isValidImdbId(imdbId) || mp instanceof ITvShowTmdbMetadataProvider && tmdbId > 0 || mp instanceof ITvShowTvdbMetadataProvider && tvdbId > 0 || tmdbId <= 0 && !MediaIdUtil.isValidImdbId(imdbId) && tvdbId <= 0) continue;
            MediaMetadata md = (MediaMetadata)metadataMap.get("tmdb");
            if (md == null) {
                try {
                    ITvShowMetadataProvider tmdb = COMPATIBLE_SCRAPERS.get("tmdb");
                    if (tmdb != null && (md = tmdb.getMetadata(options)) != null) {
                        metadataMap.put("tmdb", md);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Could not get a result from scraper: {}", (Object)e.getMessage());
                }
            }
            if (md == null) continue;
            if (tmdbId == 0 && (id = md.getId("tmdb")) != null) {
                try {
                    tmdbId = id instanceof Integer ? (Integer)id : Integer.parseInt(id.toString());
                }
                catch (Exception ignored) {
                    LOGGER.trace("could not parse tmdb id: - {}", md.getId("tmdb"));
                }
            }
            if (!MediaIdUtil.isValidImdbId(imdbId) && MediaIdUtil.isValidImdbId((String)md.getId("imdb"))) {
                imdbId = (String)md.getId("imdb");
            }
            if (tvdbId != 0 || (id = md.getId("tvdb")) == null) break;
            try {
                if (id instanceof Integer) {
                    tvdbId = (Integer)id;
                    break;
                }
                tvdbId = Integer.parseInt(id.toString());
            }
            catch (Exception ignored) {
                LOGGER.trace("could not parse tvdb id: - {}", md.getId("tvdb"));
            }
            break;
        }
        if (MediaIdUtil.isValidImdbId(imdbId)) {
            options.setImdbId(imdbId);
        }
        if (tmdbId > 0) {
            options.setTmdbId(tmdbId);
        }
        if (tvdbId > 0) {
            options.setId("tvdb", String.valueOf(tvdbId));
        }
        return metadataMap;
    }

    protected static class TvShowMetadataProviderWorker
    implements Callable<MediaMetadata> {
        private final ITvShowMetadataProvider metadataProvider;
        private final TvShowSearchAndScrapeOptions mediaScrapeOptions;

        TvShowMetadataProviderWorker(ITvShowMetadataProvider metadataProvider, TvShowSearchAndScrapeOptions mediaScrapeOptions) {
            this.metadataProvider = metadataProvider;
            this.mediaScrapeOptions = mediaScrapeOptions;
        }

        @Override
        public MediaMetadata call() throws Exception {
            return this.metadataProvider.getMetadata(this.mediaScrapeOptions);
        }
    }

    protected static class TvShowEpisodeMetadataProviderWorker
    implements Callable<MediaMetadata> {
        private final ITvShowMetadataProvider metadataProvider;
        private final TvShowEpisodeSearchAndScrapeOptions mediaScrapeOptions;

        TvShowEpisodeMetadataProviderWorker(ITvShowMetadataProvider metadataProvider, TvShowEpisodeSearchAndScrapeOptions mediaScrapeOptions) {
            this.metadataProvider = metadataProvider;
            this.mediaScrapeOptions = mediaScrapeOptions;
        }

        @Override
        public MediaMetadata call() throws Exception {
            return this.metadataProvider.getMetadata(this.mediaScrapeOptions);
        }
    }
}

