/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.tasks.TrailerDownloadTask;
import org.tinymediamanager.core.tasks.YtDownloadTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;

public class TvShowTrailerDownloadTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowTrailerDownloadTask.class);
    private final TvShow tvShow;
    private final List<TvShowTrailerNaming> trailernames = new ArrayList<TvShowTrailerNaming>();
    private final TrailerQuality desiredQuality;
    private final TrailerSources desiredSource;
    private TmmTask task;

    public TvShowTrailerDownloadTask(TvShow tvShow) {
        super(TmmResourceBundle.getString("trailer.download") + " - " + tvShow.getTitle(), 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.tvShow = tvShow;
        this.trailernames.addAll(TvShowModuleManager.getInstance().getSettings().getTrailerFilenames());
        this.desiredSource = TvShowModuleManager.getInstance().getSettings().getTrailerSource();
        this.desiredQuality = TvShowModuleManager.getInstance().getSettings().getTrailerQuality();
    }

    @Override
    protected void doInBackground() {
        if (!this.isFeatureEnabled()) {
            return;
        }
        LinkedHashSet<MediaTrailer> trailers = new LinkedHashSet<MediaTrailer>();
        for (MediaTrailer trailer : this.tvShow.getTrailer()) {
            if (!this.desiredSource.containsSource(trailer.getProvider())) continue;
            if (this.desiredSource == TrailerSources.YOUTUBE) {
                trailers.add(trailer);
                continue;
            }
            if (!this.desiredQuality.containsQuality(trailer.getQuality())) continue;
            trailers.add(trailer);
        }
        for (MediaTrailer trailer : this.tvShow.getTrailer()) {
            if (!this.desiredQuality.containsQuality(trailer.getQuality())) continue;
            trailers.add(trailer);
        }
        trailers.addAll(this.tvShow.getTrailer());
        if (trailers.isEmpty()) {
            LOGGER.info("No trailers available for '{}'", (Object)this.tvShow.getTitle());
            return;
        }
        LOGGER.info("Downloading trailer for '{}'", (Object)this.tvShow.getTitle());
        for (MediaTrailer trailer : trailers) {
            String url = trailer.getUrl();
            if (StringUtils.isBlank((CharSequence)url) && StringUtils.isBlank((CharSequence)trailer.getId())) {
                LOGGER.trace("Trailer has neither an ID, nor an url: {}", (Object)trailer);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)url) && url.toLowerCase(Locale.ROOT).startsWith("http")) continue;
            try {
                LOGGER.debug("try to download trailer '{}'", (Object)trailer);
                Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(url);
                this.task = matcher.matches() ? new YtDownloadTask(trailer, this.desiredQuality, TvShowModuleManager.getInstance().getSettings().isUseYtDlp()){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return TvShowTrailerDownloadTask.this.getDestination();
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return TvShowTrailerDownloadTask.this.tvShow;
                    }
                } : new TrailerDownloadTask(trailer){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return TvShowTrailerDownloadTask.this.getDestination();
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return TvShowTrailerDownloadTask.this.tvShow;
                    }
                };
                if (this.cancel) {
                    return;
                }
                this.task.addListener(taskEvent -> {
                    this.setProgressDone(taskEvent.getProgressDone());
                    this.setTaskDescription(taskEvent.getTaskDescription());
                    this.setWorkUnits(taskEvent.getWorkUnits());
                    this.informListeners();
                });
                this.task.run();
                if (this.task.getState() != TmmTaskHandle.TaskState.FINISHED && this.task.getState() != TmmTaskHandle.TaskState.CANCELLED) continue;
                break;
            }
            catch (Exception e) {
                LOGGER.debug("could download trailer - {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.task != null) {
            this.task.cancel();
        }
    }

    protected Path getDestination() {
        String filename = !this.trailernames.isEmpty() ? this.tvShow.getTrailerFilename(this.trailernames.get(0)) : this.tvShow.getTrailerFilename(TvShowTrailerNaming.TVSHOW_TRAILER);
        return this.tvShow.getPathNIO().resolve(filename);
    }
}

