/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;

public class MovieUpgradeTasks
extends UpgradeTasks {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieUpgradeTasks.class);

    @Override
    public void performSettingsUpgrades() {
        MovieSettings settings = MovieModuleManager.getInstance().getSettings();
        if (settings.getVersion() == 0) {
            settings.setVersion(5000);
        }
        LOGGER.info("Current movie settings version: {}", (Object)settings.getVersion());
        if (settings.getVersion() < 5201) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5201);
            LinkedHashSet<MovieScraperMetadataConfig> metadataConfig = new LinkedHashSet<MovieScraperMetadataConfig>();
            for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
                if (config != MovieScraperMetadataConfig.ENGLISH_TITLE && !settings.getScraperMetadataConfig().contains(config)) continue;
                metadataConfig.add(config);
            }
            settings.setScraperMetadataConfig(new ArrayList<MovieScraperMetadataConfig>(metadataConfig));
            settings.setEnglishTitle(true);
            settings.setVersion(5201);
        }
        settings.saveSettings();
    }

    @Override
    public void performDbUpgrades() {
        MovieModuleManager module = MovieModuleManager.getInstance();
        MovieList movieList = module.getMovieList();
        if (module.getDbVersion() == 0) {
            module.setDbVersion(5000);
        }
        LOGGER.info("Current movie DB version: {}", (Object)module.getDbVersion());
        if (module.getDbVersion() < 5001) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5001);
            for (Movie movie : movieList.getMovies()) {
                for (MediaFile mf : movie.getMediaFiles(MediaFileType.LOGO)) {
                    movie.removeFromMediaFiles(mf);
                    mf.setType(MediaFileType.CLEARLOGO);
                    movie.addToMediaFiles(mf);
                }
                String logoUrl = movie.getArtworkUrl(MediaFileType.LOGO);
                if (StringUtils.isNotBlank((CharSequence)logoUrl)) {
                    movie.removeArtworkUrl(MediaFileType.LOGO);
                    String clearlogoUrl = movie.getArtworkUrl(MediaFileType.CLEARLOGO);
                    if (StringUtils.isBlank((CharSequence)clearlogoUrl)) {
                        movie.setArtworkUrl(logoUrl, MediaFileType.CLEARLOGO);
                    }
                }
                this.registerForSaving(movie);
            }
            module.setDbVersion(5001);
        }
        if (module.getDbVersion() < 5003) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5003);
            for (Movie movie : movieList.getMovies()) {
                if (!MovieUpgradeTasks.fixRatings(movie)) continue;
                this.registerForSaving(movie);
            }
            module.setDbVersion(5003);
        }
        if (module.getDbVersion() < 5004) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5004);
            for (Movie movie : movieList.getMovies()) {
                if (!MovieUpgradeTasks.fixHDR(movie)) continue;
                this.registerForSaving(movie);
            }
            module.setDbVersion(5004);
        }
        if (module.getDbVersion() < 5005) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5005);
            for (Movie movie : movieList.getMovies()) {
                boolean changed = this.migrateIds(movie);
                if (!changed) continue;
                this.registerForSaving(movie);
            }
            module.setDbVersion(5005);
        }
        if (module.getDbVersion() < 5201) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5201);
            movieList.getMovies().forEach(x$0 -> this.registerForSaving((MediaEntity)x$0));
            module.setDbVersion(5201);
        }
        if (module.getDbVersion() < 5202) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5202);
            for (Movie movie : movieList.getMovies()) {
                for (MediaFile mf : movie.getMediaFiles()) {
                    if (mf.getCRC32().isEmpty() || mf.getCRC32().length() >= 8) continue;
                    mf.setCRC32(String.format("%8s", mf.getCRC32()).replace(' ', '0'));
                    this.registerForSaving(movie);
                }
            }
            module.setDbVersion(5202);
        }
        if (module.getDbVersion() < 5203) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5203);
            for (Movie movie : movieList.getMovies()) {
                this.convertRating("tomatoes", "tomatometerallcritics", movie);
                this.convertRating("audience", "tomatometeravgcritics", movie);
                this.convertRating("popcorn", "tomatometeravgcritics", movie);
            }
            module.setDbVersion(5203);
        }
        this.saveAll();
    }

    @Override
    protected void saveAll() {
        for (MediaEntity mediaEntity : this.entitiesToSave) {
            if (mediaEntity instanceof Movie) {
                Movie movie = (Movie)mediaEntity;
                MovieModuleManager.getInstance().persistMovie(movie);
                continue;
            }
            if (!(mediaEntity instanceof MovieSet)) continue;
            MovieSet movieSet = (MovieSet)mediaEntity;
            MovieModuleManager.getInstance().persistMovieSet(movieSet);
        }
    }
}

