/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowReloadMediaInformationTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRebuildMediainfoXmlAction
extends TmmAction {
    public TvShowRebuildMediainfoXmlAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.rebuildmediainfoxml"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.rebuildmediainfoxml"));
        this.putValue("SmallIcon", IconManager.MEDIAINFO);
        this.putValue("SwingLargeIconKey", IconManager.MEDIAINFO);
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        if (Boolean.FALSE.equals(TmmProperties.getInstance().getPropertyAsBoolean("tvshow.hidedeletemediainfoxmlhint"))) {
            Iterator<TvShowEpisode> checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)((Object)checkBox), 0.91667);
            ((JComponent)((Object)checkBox)).setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            Object[] params = new Object[]{TmmResourceBundle.getString("tvshow.deletemediainfoxml.desc"), checkBox};
            int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("tvshow.deletemediainfoxml"), 0, 3, null, options, null);
            if (((AbstractButton)((Object)checkBox)).isSelected()) {
                TmmProperties.getInstance().putProperty("tvshow.hidedeletemediainfoxmlhint", String.valueOf(((AbstractButton)((Object)checkBox)).isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        for (TvShow tvShow : selectedObjects.getTvShows()) {
            tvShow.getMediaFiles(MediaFileType.MEDIAINFO).forEach(mediaFile -> {
                Utils.deleteFileSafely(mediaFile.getFileAsPath());
                tvShow.removeFromMediaFiles((MediaFile)mediaFile);
            });
        }
        for (TvShowEpisode episode : selectedObjects.getEpisodesRecursive()) {
            episode.getMediaFiles(MediaFileType.MEDIAINFO).forEach(mediaFile -> {
                Utils.deleteFileSafely(mediaFile.getFileAsPath());
                episode.removeFromMediaFiles((MediaFile)mediaFile);
            });
        }
        TvShowReloadMediaInformationTask task = new TvShowReloadMediaInformationTask(selectedObjects.getTvShows(), selectedObjects.getEpisodesRecursive());
        TmmTaskManager.getInstance().addMainTask(task);
    }
}

