/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.converter;

import java.util.Locale;
import org.jdesktop.beansbinding.Converter;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;

public class RatingConverter<T extends MediaRating>
extends Converter<T, String> {
    private final Locale locale = Locale.getDefault();

    public String convertForward(T rating) {
        if (rating != null) {
            boolean defaultUserRating = switch (((MediaRating)rating).getId()) {
                case "default", "user", "NFO" -> true;
                default -> false;
            };
            if (((MediaRating)rating).getVotes() > 1 && !defaultUserRating) {
                return String.format(this.locale, "%.1f / %,d (%,d %s / %s)", Float.valueOf(((MediaRating)rating).getRating()), ((MediaRating)rating).getMaxValue(), ((MediaRating)rating).getVotes(), TmmResourceBundle.getString("metatag.votes"), ((MediaRating)rating).getId());
            }
            if (((MediaRating)rating).getVotes() > 1 && defaultUserRating) {
                return String.format(this.locale, "%.1f / %,d (%,d %s)", Float.valueOf(((MediaRating)rating).getRating()), ((MediaRating)rating).getMaxValue(), ((MediaRating)rating).getVotes(), TmmResourceBundle.getString("metatag.votes"));
            }
            if (!defaultUserRating && ((MediaRating)rating).getVotes() >= 1) {
                return String.format(this.locale, "%.1f / %,d (%s)", Float.valueOf(((MediaRating)rating).getRating()), ((MediaRating)rating).getMaxValue(), ((MediaRating)rating).getId());
            }
            return String.format(this.locale, "%.1f / %,d", Float.valueOf(((MediaRating)rating).getRating()), ((MediaRating)rating).getMaxValue());
        }
        return "";
    }

    public T convertReverse(String arg0) {
        return null;
    }
}

