/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.nio.file.Path;
import java.text.Collator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.RuleBasedCollator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.IconManager;

public abstract class TmmTableFormat<E>
implements AdvancedTableFormat<E> {
    protected List<Column> columns = new ArrayList<Column>();

    protected FontMetrics getFontMetrics() {
        Font defaultFont = UIManager.getFont("Table.font");
        if (defaultFont == null) {
            defaultFont = UIManager.getFont("Label.font");
        }
        Canvas canvas = new Canvas();
        return canvas.getFontMetrics(defaultFont);
    }

    protected int getCellPadding() {
        return this.getFontMetrics().stringWidth("xx1");
    }

    protected void addColumn(Column column) {
        this.columns.add(column);
    }

    public Class<?> getColumnClass(int i) {
        return this.columns.get((int)i).columnClass;
    }

    public Comparator<?> getColumnComparator(int i) {
        return this.columns.get((int)i).columnComparator;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnName(int i) {
        return this.columns.get((int)i).columnTitle;
    }

    public Object getColumnValue(E e, int i) {
        return this.columns.get((int)i).columnValue.apply(e);
    }

    public String getHeaderTooltip(int i) {
        Column column = this.columns.get(i);
        if (StringUtils.isNotBlank((CharSequence)column.headerTooltip)) {
            return column.headerTooltip;
        }
        return null;
    }

    public String getColumnTooltip(E e, int i) {
        Column column = this.columns.get(i);
        if (column.cellTooltip != null) {
            return column.cellTooltip.apply(e);
        }
        return null;
    }

    public String getColumnIdentifier(int i) {
        return this.columns.get((int)i).columnIdentifier;
    }

    public TableCellRenderer getCellRenderer(int i) {
        return this.columns.get((int)i).cellRenderer;
    }

    public ImageIcon getHeaderIcon(int i) {
        return this.columns.get((int)i).headerIcon;
    }

    public boolean getColumnResizeable(int i) {
        return this.columns.get((int)i).columnResizeable;
    }

    public int getMinWidth(int i) {
        return this.columns.get((int)i).minWidth;
    }

    public int getMaxWidth(int i) {
        return this.columns.get((int)i).maxWidth;
    }

    public boolean isColumnDefaultHidden(int i) {
        return this.columns.get((int)i).defaultHidden;
    }

    protected ImageIcon getCheckIcon(boolean bool) {
        if (bool) {
            return IconManager.TABLE_OK;
        }
        return IconManager.TABLE_NOT_OK;
    }

    protected ImageIcon getNewIcon(boolean bool) {
        if (bool) {
            return IconManager.NEW_GREEN;
        }
        return null;
    }

    protected class Column {
        private final String columnTitle;
        private final String columnIdentifier;
        private final Function<E, ?> columnValue;
        private final Class<?> columnClass;
        private String headerTooltip = null;
        private Function<E, String> cellTooltip = null;
        private Comparator<?> columnComparator = null;
        private TableCellRenderer cellRenderer = null;
        private ImageIcon headerIcon = null;
        private boolean columnResizeable = true;
        private int minWidth = 0;
        private int maxWidth = 0;
        private boolean defaultHidden = false;

        public Column(String title, String identifier, Function<E, ?> value, Class<?> clazz) {
            this.columnTitle = title;
            this.columnIdentifier = identifier;
            this.columnValue = value;
            this.columnClass = clazz;
            this.minWidth = (int)((double)Settings.getInstance().getFontSize() * 2.3);
        }

        public void setColumnComparator(Comparator<?> comparator) {
            this.columnComparator = comparator;
        }

        public void setCellRenderer(TableCellRenderer renderer) {
            this.cellRenderer = renderer;
        }

        public void setHeaderIcon(ImageIcon icon) {
            this.headerIcon = icon;
        }

        public void setColumnResizeable(boolean resizeable) {
            this.columnResizeable = resizeable;
        }

        public void setMinWidth(int minWidth) {
            this.minWidth = minWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public void setHeaderTooltip(String tooltip) {
            this.headerTooltip = tooltip;
        }

        public void setCellTooltip(Function<E, String> tooltipFunction) {
            this.cellTooltip = tooltipFunction;
        }

        public void setDefaultHidden(boolean defaultHidden) {
            this.defaultHidden = defaultHidden;
        }
    }

    public static class CertificationComparator
    implements Comparator<MediaCertification> {
        @Override
        public int compare(MediaCertification arg0, MediaCertification arg1) {
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            return arg0.toString().compareTo(arg1.toString());
        }
    }

    public static class FileSizeComparator
    implements Comparator<String> {
        private final Pattern pattern = Pattern.compile("(.*) ([kMGT]?)");
        private final NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());

        @Override
        public int compare(String arg0, String arg1) {
            long size0 = this.parseSize(arg0);
            long size1 = this.parseSize(arg1);
            return Long.compare(size0, size1);
        }

        private long parseSize(String sizeAsString) {
            long size = 0L;
            if (StringUtils.isBlank((CharSequence)sizeAsString)) {
                return size;
            }
            Matcher matcher = this.pattern.matcher(sizeAsString);
            if (matcher.find()) {
                try {
                    float value = this.parseLocalizedNumber(matcher.group(1));
                    String unit = matcher.group(2);
                    size = "T".equals(unit) ? (long)(value * 1000.0f * 1000.0f * 1000.0f * 1000.0f) : ("G".equals(unit) ? (long)(value * 1000.0f * 1000.0f * 1000.0f) : ("M".equals(unit) ? (long)(value * 1000.0f * 1000.0f) : ("k".equals(unit) ? (long)(value * 1000.0f) : (long)value)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return size;
        }

        private float parseLocalizedNumber(String numberStr) {
            try {
                return this.nf.parse(numberStr).floatValue();
            }
            catch (Exception e) {
                try {
                    return Float.parseFloat(numberStr.replace(",", "."));
                }
                catch (Exception ex) {
                    return 0.0f;
                }
            }
        }
    }

    public static class VideoFormatComparator
    implements Comparator<String> {
        @Override
        public int compare(String arg0, String arg1) {
            int value1 = StringUtils.isBlank((CharSequence)arg0) ? -1 : MetadataUtil.parseInt(arg0.replace("p", ""), -1);
            int value2 = StringUtils.isBlank((CharSequence)arg1) ? -1 : MetadataUtil.parseInt(arg1.replace("p", ""), -1);
            return Integer.compare(value1, value2);
        }
    }

    public static class DateTimeComparator
    implements Comparator<Date> {
        @Override
        public int compare(Date arg0, Date arg1) {
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            return arg0.compareTo(arg1);
        }
    }

    public static class DateComparator
    implements Comparator<Date> {
        DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

        @Override
        public int compare(Date arg0, Date arg1) {
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            String date0 = this.dateFormat.format(arg0);
            String date1 = this.dateFormat.format(arg1);
            return date0.compareTo(date1);
        }
    }

    public static class ImageComparator
    implements Comparator<ImageIcon> {
        @Override
        public int compare(ImageIcon arg0, ImageIcon arg1) {
            return Integer.compare(this.getImageValue(arg0), this.getImageValue(arg1)) * -1;
        }

        private int getImageValue(ImageIcon imageIcon) {
            if (imageIcon == IconManager.TABLE_OK) {
                return 8;
            }
            if (imageIcon == IconManager.TABLE_PROBLEM) {
                return 4;
            }
            if (imageIcon == IconManager.TABLE_NOT_OK) {
                return 2;
            }
            if (imageIcon != null) {
                return 1;
            }
            return -1;
        }
    }

    public static class FloatComparator
    implements Comparator<Float> {
        @Override
        public int compare(Float arg0, Float arg1) {
            if (arg0 == null) {
                arg0 = Float.valueOf(0.0f);
            }
            if (arg1 == null) {
                arg1 = Float.valueOf(0.0f);
            }
            return Float.compare(arg0.floatValue(), arg1.floatValue());
        }
    }

    public static class IntegerComparator
    implements Comparator<Integer> {
        @Override
        public int compare(Integer arg0, Integer arg1) {
            if (arg0 == null) {
                arg0 = 0;
            }
            if (arg1 == null) {
                arg1 = 0;
            }
            return Integer.compare(arg0, arg1);
        }
    }

    public static class PathComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path arg0, Path arg1) {
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            return arg0.toAbsolutePath().compareTo(arg1.toAbsolutePath());
        }
    }

    public static class BooleanComparator
    implements Comparator<Boolean> {
        @Override
        public int compare(Boolean arg0, Boolean arg1) {
            return Boolean.compare(arg0, arg1);
        }
    }

    public static class StringComparator
    implements Comparator<String> {
        protected Collator stringCollator;

        public StringComparator() {
            RuleBasedCollator defaultCollator = (RuleBasedCollator)Collator.getInstance();
            try {
                this.stringCollator = new RuleBasedCollator(defaultCollator.getRules().replace("<'_'", "<' '<'_'"));
            }
            catch (Exception e) {
                this.stringCollator = defaultCollator;
            }
        }

        @Override
        public int compare(String arg0, String arg1) {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{arg0, arg1})) {
                return 0;
            }
            if (StringUtils.isBlank((CharSequence)arg0)) {
                return -1;
            }
            if (StringUtils.isBlank((CharSequence)arg1)) {
                return 1;
            }
            if (this.stringCollator != null) {
                String first = StrgUtils.normalizeString(arg0.toLowerCase(Locale.ROOT));
                String second = StrgUtils.normalizeString(arg1.toLowerCase(Locale.ROOT));
                return this.stringCollator.compare(first, second);
            }
            return arg0.toLowerCase(Locale.ROOT).compareTo(arg1.toLowerCase(Locale.ROOT));
        }
    }
}

