/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.label;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;

public class LinkLabel
extends JLabel {
    protected String link;
    protected ActionListener activeListener = null;

    public LinkLabel(String text) {
        super(text);
        this.setLink(text);
    }

    public LinkLabel() {
        this((String)null);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Font font = UIManager.getFont("Label.font");
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        attributes.put(TextAttribute.FOREGROUND, UIManager.getColor("Component.linkColor"));
        this.setFont(font.deriveFont(attributes));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.enableEvents(16L);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setLink(text);
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    @Override
    protected void processMouseEvent(MouseEvent evt) {
        super.processMouseEvent(evt);
        if (evt.getID() == 501 && StringUtils.isNotBlank((CharSequence)this.getLink())) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getLink()));
        }
    }

    public void addActionListener(ActionListener listener) {
        if (this.activeListener != null) {
            this.removeActionListener(this.activeListener);
        }
        this.listenerList.add(ActionListener.class, listener);
        this.activeListener = listener;
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    protected void fireActionPerformed(ActionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ActionListener.class) continue;
            ActionListener listener = (ActionListener)listeners[i + 1];
            listener.actionPerformed(evt);
        }
    }
}

