/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import org.jupnp.DefaultUpnpServiceConfiguration;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.UpnpServiceImpl;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.binding.xml.RecoveringUDA10DeviceDescriptorBinderImpl;
import org.jupnp.binding.xml.RecoveringUDA10ServiceDescriptorBinderImpl;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.DiscoveryOptions;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.registry.Registry;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.DatagramProcessor;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamServer;
import org.tinymediamanager.thirdparty.upnp.StreamServerConfigurationImpl;
import org.tinymediamanager.thirdparty.upnp.TmmDatagramProcessor;
import org.tinymediamanager.thirdparty.upnp.TmmLocalDevice;
import org.tinymediamanager.thirdparty.upnp.TmmStreamClientImpl;
import org.tinymediamanager.thirdparty.upnp.TmmStreamServerImpl;
import org.tinymediamanager.thirdparty.upnp.UpnpListener;

public class TmmUpnpService
extends UpnpServiceImpl {
    public TmmUpnpService(int port) {
        this(port, true);
    }

    public TmmUpnpService(int port, final boolean createServer) {
        super((UpnpServiceConfiguration)new DefaultUpnpServiceConfiguration(port){

            public DeviceDescriptorBinder getDeviceDescriptorBinderUDA10() {
                return new RecoveringUDA10DeviceDescriptorBinderImpl();
            }

            public ServiceDescriptorBinder getServiceDescriptorBinderUDA10() {
                return new RecoveringUDA10ServiceDescriptorBinderImpl();
            }

            public StreamClient createStreamClient() {
                return new TmmStreamClientImpl(new StreamClientConfigurationImpl(this.createDefaultExecutorService()));
            }

            public StreamServer createStreamServer(NetworkAddressFactory networkAddressFactory) {
                if (createServer) {
                    return new TmmStreamServerImpl(new StreamServerConfigurationImpl(networkAddressFactory.getStreamListenPort()), this.createDefaultExecutorService());
                }
                return null;
            }

            public DatagramProcessor getDatagramProcessor() {
                return new TmmDatagramProcessor();
            }
        });
    }

    protected Registry createRegistry(ProtocolFactory protocolFactory) {
        Registry result = super.createRegistry(protocolFactory);
        result.addListener(UpnpListener.getListener());
        result.addDevice((LocalDevice)TmmLocalDevice.createMediaServerDevice(), new DiscoveryOptions(true));
        return result;
    }
}

