/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.movie.tasks.MovieTrailerDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.thirdparty.trakttv.MovieSyncTraktTvTask;
import org.tinymediamanager.ui.movies.dialogs.MovieChooserDialog;

public class MovieScrapeTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieScrapeTask.class);
    private final MovieScrapeParams movieScrapeParams;
    private final List<Movie> smartScrapeList;
    private boolean runInBackground;

    public MovieScrapeTask(MovieScrapeParams movieScrapeParams) {
        super(TmmResourceBundle.getString("movie.scraping"));
        this.movieScrapeParams = movieScrapeParams;
        this.smartScrapeList = new ArrayList<Movie>(0);
        this.runInBackground = false;
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    @Override
    protected void doInBackground() {
        MediaScraper mediaMetadataScraper = this.movieScrapeParams.searchAndScrapeOptions.getMetadataScraper();
        if (!mediaMetadataScraper.isEnabled()) {
            return;
        }
        LOGGER.info("Scraping {} movies with '{}'", (Object)this.movieScrapeParams.moviesToScrape.size(), (Object)mediaMetadataScraper.getMediaProvider().getProviderInfo().getId());
        this.initThreadPool(3, "scrape");
        for (Movie movie : this.movieScrapeParams.moviesToScrape) {
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        if (!(this.smartScrapeList.isEmpty() || GraphicsEnvironment.isHeadless() || this.runInBackground)) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    int selectedCount = this.smartScrapeList.size();
                    int index = 0;
                    do {
                        Movie movie = this.smartScrapeList.get(index);
                        MovieChooserDialog dialogMovieChooser = new MovieChooserDialog(movie, index, selectedCount);
                        dialogMovieChooser.setVisible(true);
                        if (!dialogMovieChooser.isContinueQueue()) break;
                        if (dialogMovieChooser.isNavigateBack()) {
                            --index;
                            continue;
                        }
                        ++index;
                    } while (index < selectedCount);
                });
            }
            catch (Exception e) {
                LOGGER.error("SmartScrape crashed - '{}'", (Object)e.getMessage());
            }
        }
        if (MovieModuleManager.getInstance().getSettings().getSyncTrakt()) {
            MovieSyncTraktTvTask task = new MovieSyncTraktTvTask(this.movieScrapeParams.moviesToScrape);
            task.setSyncCollection(MovieModuleManager.getInstance().getSettings().getSyncTraktCollection());
            task.setSyncWatched(MovieModuleManager.getInstance().getSettings().getSyncTraktWatched());
            task.setSyncRating(MovieModuleManager.getInstance().getSettings().getSyncTraktRating());
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
        LOGGER.info("Finished scraping movies - took {} ms", (Object)this.getRuntime());
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    public static class MovieScrapeParams {
        private final List<Movie> moviesToScrape;
        private final List<MovieScraperMetadataConfig> scraperMetadataConfig;
        private final MovieSearchAndScrapeOptions searchAndScrapeOptions;
        private boolean doSearch;
        private boolean overwriteExistingItems;

        public MovieScrapeParams(List<Movie> moviesToScrape, MovieSearchAndScrapeOptions searchAndScrapeOptions, List<MovieScraperMetadataConfig> scraperMetadataConfig) {
            this.moviesToScrape = new ArrayList<Movie>(moviesToScrape);
            this.searchAndScrapeOptions = searchAndScrapeOptions;
            this.scraperMetadataConfig = new ArrayList<MovieScraperMetadataConfig>(scraperMetadataConfig);
            this.doSearch = true;
            this.overwriteExistingItems = true;
        }

        public MovieScrapeParams setDoSearch(boolean doSearch) {
            this.doSearch = doSearch;
            return this;
        }

        public MovieScrapeParams setOverwriteExistingItems(boolean overwriteExistingItems) {
            this.overwriteExistingItems = overwriteExistingItems;
            return this;
        }
    }

    private class Worker
    implements Runnable {
        private MovieList movieList;
        private final Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block25: {
                this.movieList = MovieModuleManager.getInstance().getMovieList();
                MediaScraper mediaMetadataScraper = MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getMetadataScraper();
                List<MediaScraper> artworkScrapers = MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getArtworkScrapers();
                List<MediaScraper> trailerScrapers = MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getTrailerScrapers();
                try {
                    MediaSearchResult result1 = null;
                    if (MovieScrapeTask.this.movieScrapeParams.doSearch) {
                        LOGGER.info("Searching for movie '{}'", (Object)this.movie.getTitle());
                        result1 = this.searchForMovie(mediaMetadataScraper);
                        if (result1 == null) {
                            List<Movie> list = MovieScrapeTask.this.smartScrapeList;
                            synchronized (list) {
                                MovieScrapeTask.this.smartScrapeList.add(this.movie);
                                return;
                            }
                        }
                    }
                    MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions);
                    options.setSearchResult(result1);
                    if (result1 != null) {
                        options.setIds(result1.getIds());
                        mediaMetadataScraper = this.movieList.getMediaScraperById(result1.getProviderId());
                    } else {
                        options.setIds(this.movie.getIds());
                    }
                    MediaMetadata md = null;
                    if (mediaMetadataScraper == null || mediaMetadataScraper.getMediaProvider() == null) break block25;
                    LOGGER.info("Scraping movie '{}' with '{}'", (Object)this.movie.getTitle(), (Object)mediaMetadataScraper.getMediaProvider().getProviderInfo().getId());
                    LOGGER.debug("=====================================================");
                    LOGGER.debug("Scrape movie metadata with scraper: " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getId() + ", " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getVersion());
                    LOGGER.debug(options.toString());
                    LOGGER.debug("=====================================================");
                    try {
                        int movieSetId;
                        md = ((IMovieMetadataProvider)mediaMetadataScraper.getMediaProvider()).getMetadata(options);
                        if (MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig.contains(MovieScraperMetadataConfig.COLLECTION) && md.getIdAsInt("tmdbSet") == 0 && !mediaMetadataScraper.getId().equals("tmdb") && (movieSetId = MetadataUtil.getMovieSetId(md.getIds())) > 0) {
                            md.setId("tmdbSet", movieSetId);
                        }
                        if (MovieScrapeTask.this.cancel) {
                            return;
                        }
                        MediaIdUtil.injectMissingIds(md.getIds(), MediaType.MOVIE);
                        if (MovieModuleManager.getInstance().getSettings().isFetchAllRatings() && MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig.contains(MovieScraperMetadataConfig.RATING)) {
                            for (MediaRating rating : ListUtils.nullSafe(RatingProvider.getRatings(md.getIds(), MovieModuleManager.getInstance().getSettings().getFetchRatingSources(), MediaType.MOVIE))) {
                                if (md.getRatings().contains(rating)) continue;
                                md.addRating(rating);
                            }
                        }
                    }
                    catch (MissingIdException e) {
                        LOGGER.warn("Missing IDs for scraping movie '{}' with '{}'", (Object)this.movie.getTitle(), (Object)mediaMetadataScraper.getId());
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "scraper.error.missingid"));
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("Could not scrape movie '{}' with '{}' - '{}'", new Object[]{this.movie.getTitle(), mediaMetadataScraper.getId(), e.getMessage()});
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.scrape.metadatamoviefailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (Exception e) {
                        LOGGER.error("Unforeseen error in movie scrape for '{}'", (Object)this.movie.getTitle(), (Object)e);
                    }
                    if (md != null && (ScraperMetadataConfig.containsAnyMetadata(MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig) || ScraperMetadataConfig.containsAnyCast(MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig))) {
                        this.movie.setMetadata(md, MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig, MovieScrapeTask.this.movieScrapeParams.overwriteExistingItems);
                        this.movie.setLastScraperId(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getMetadataScraper().getId());
                        this.movie.setLastScrapeLanguage(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getLanguage().name());
                        if (MovieModuleManager.getInstance().getSettings().isRenameAfterScrape()) {
                            MovieRenameTask task = new MovieRenameTask(Collections.singletonList(this.movie));
                            task.run();
                        }
                        if (ScraperMetadataConfig.containsAnyCast(MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig) && MovieModuleManager.getInstance().getSettings().isWriteActorImages()) {
                            this.movie.writeActorImages(MovieScrapeTask.this.movieScrapeParams.overwriteExistingItems);
                        }
                    }
                    if (MovieScrapeTask.this.cancel) {
                        return;
                    }
                    if (ScraperMetadataConfig.containsAnyArtwork(MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig)) {
                        this.movie.setArtwork(this.getArtwork(this.movie, md, artworkScrapers), MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig, MovieScrapeTask.this.movieScrapeParams.overwriteExistingItems);
                    }
                    if (MovieScrapeTask.this.cancel) {
                        return;
                    }
                    if (MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig.contains(MovieScraperMetadataConfig.TRAILER)) {
                        this.movie.setTrailers(this.getTrailers(this.movie, md, trailerScrapers));
                        this.movie.saveToDb();
                        this.movie.writeNFO();
                        if (MovieModuleManager.getInstance().getSettings().isUseTrailerPreference() && MovieModuleManager.getInstance().getSettings().isAutomaticTrailerDownload() && this.movie.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !this.movie.getTrailer().isEmpty()) {
                            TmmTaskManager.getInstance().addDownloadTask(new MovieTrailerDownloadTask(this.movie));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Could not scrape movie '{}' - '{}'", (Object)this.movie.getTitle(), (Object)e.getMessage());
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieScraper", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }

        private MediaSearchResult searchForMovie(MediaScraper mediaMetadataProvider) throws ScrapeException {
            List<MediaSearchResult> results = this.movieList.searchMovie(this.movie.getTitle(), this.movie.getYear(), this.movie.getIds(), mediaMetadataProvider);
            MediaSearchResult result = null;
            if (ListUtils.isNotEmpty(results)) {
                result = results.get(0);
                if (results.size() > 1) {
                    MediaSearchResult result2 = results.get(1);
                    if (result.getScore() == result2.getScore()) {
                        LOGGER.warn("Two identical results for '{}', can't decide which to take - ignore result", (Object)this.movie.getTitle());
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "movie.scrape.toosimilar"));
                        return null;
                    }
                }
                double scraperTreshold = MovieModuleManager.getInstance().getSettings().getScraperThreshold();
                LOGGER.debug("using threshold from settings of {}", (Object)scraperTreshold);
                if ((double)result.getScore() < scraperTreshold) {
                    LOGGER.warn("Score ({}) is lower than minimum score ({}) for '{}' - ignore result", new Object[]{Float.valueOf(result.getScore()), scraperTreshold, this.movie.getTitle()});
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "movie.scrape.toolowscore", new String[]{String.format("%.2f", scraperTreshold)}));
                    return null;
                }
            } else {
                LOGGER.info("No result found for '{}'", (Object)this.movie.getTitle());
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "movie.scrape.nomatchfound"));
            }
            return result;
        }

        private List<MediaArtwork> getArtwork(Movie movie, MediaMetadata metadata, List<MediaScraper> artworkScrapers) {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE);
            options.setDataFromOtherOptions(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(metadata);
            if (metadata != null) {
                options.addIds(metadata.getIds());
            }
            if (movie.isStacked()) {
                options.setId("mediaFile", new ArrayList<MediaFile>(movie.getMediaFiles(MediaFileType.VIDEO)));
            } else {
                options.setId("mediaFile", movie.getMainFile());
            }
            options.setLanguage(MovieModuleManager.getInstance().getSettings().getDefaultImageScraperLanguage());
            options.setFanartSize(MovieModuleManager.getInstance().getSettings().getImageFanartSize());
            options.setPosterSize(MovieModuleManager.getInstance().getSettings().getImagePosterSize());
            artworkScrapers.parallelStream().forEach(scraper -> {
                IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)scraper.getMediaProvider();
                try {
                    lock.writeLock().lock();
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (MissingIdException ignored) {
                    LOGGER.info("Missing IDs for scraping movie artwork of '{}' with '{}'", (Object)movie.getTitle(), (Object)scraper.getId());
                }
                catch (ScrapeException e) {
                    LOGGER.error("Could not scrape movie artwork of '{}' with '{}' - '{}'", new Object[]{movie.getTitle(), scraper.getId(), e.getMessage()});
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.scrape.movieartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (Exception e) {
                    LOGGER.error("Unforeseen error in movie artwork scrape for '{}'", (Object)movie.getTitle(), (Object)e);
                }
                finally {
                    lock.writeLock().unlock();
                }
            });
            return artwork;
        }

        private List<MediaTrailer> getTrailers(Movie movie, MediaMetadata metadata, List<MediaScraper> trailerScrapers) {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
            TrailerSearchAndScrapeOptions options = new TrailerSearchAndScrapeOptions(MediaType.MOVIE);
            options.setDataFromOtherOptions(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions);
            options.setMetadata(metadata);
            if (metadata != null) {
                options.addIds(metadata.getIds());
            }
            trailerScrapers.parallelStream().forEach(trailerScraper -> {
                IMovieTrailerProvider trailerProvider = (IMovieTrailerProvider)trailerScraper.getMediaProvider();
                try {
                    lock.writeLock().lock();
                    trailers.addAll(trailerProvider.getTrailers(options));
                }
                catch (MissingIdException e) {
                    LOGGER.info("Missing IDs for scraping movie trailers of '{}' with '{}'", (Object)movie.getTitle(), (Object)trailerScraper.getId());
                }
                catch (ScrapeException e) {
                    LOGGER.error("Could not scrape movie trailers of '{}' with '{}' - '{}'", new Object[]{movie.getTitle(), trailerScraper.getId(), e.getMessage()});
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (Exception e) {
                    LOGGER.error("Unforeseen error in movie trailer scrape for '{}'", (Object)movie.getTitle(), (Object)e);
                }
                finally {
                    lock.writeLock().unlock();
                }
            });
            return trailers;
        }
    }
}

