/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.jmte;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieNamedFirstCharacterRenderer
implements NamedRenderer {
    private static final Pattern FIRST_ALPHANUM_PATTERN = Pattern.compile("[\\p{L}\\d]");

    public String render(Object o, String s, Locale locale, Map<String, Object> map) {
        Matcher matcher;
        String source;
        if (o instanceof String && StringUtils.isNotBlank((CharSequence)(source = (String)o)) && (matcher = FIRST_ALPHANUM_PATTERN.matcher(source = StrgUtils.convertToAscii(source, false))).find()) {
            String first = matcher.group();
            if (first.matches("\\p{L}")) {
                return first.toUpperCase(Locale.ROOT);
            }
            return MovieModuleManager.getInstance().getSettings().getRenamerFirstCharacterNumberReplacement();
        }
        if (o instanceof Number) {
            return MovieModuleManager.getInstance().getSettings().getRenamerFirstCharacterNumberReplacement();
        }
        if (o instanceof Date) {
            return MovieModuleManager.getInstance().getSettings().getRenamerFirstCharacterNumberReplacement();
        }
        return "";
    }

    public String getName() {
        return "first";
    }

    public RenderFormatInfo getFormatInfo() {
        return null;
    }

    public Class<?>[] getSupportedClasses() {
        return new Class[]{Date.class, String.class, Integer.class, Long.class};
    }
}

