/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.jmte;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class NamedSplitRenderer
implements NamedRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedSplitRenderer.class);

    public String render(Object o, String s, Locale locale, Map<String, Object> map) {
        String string;
        if (o == null) {
            return "";
        }
        if (o instanceof String && StringUtils.isNotBlank((CharSequence)(string = (String)o))) {
            String[] split = string.split(",");
            if (split.length == 1) {
                LOGGER.trace("there was nothing to split: {}", o);
                return string;
            }
            if (s != null && s.contains(",")) {
                String[] fromTo = s.split(",");
                if (fromTo.length == 2) {
                    int from = MetadataUtil.parseInt(fromTo[0], -1);
                    int to = MetadataUtil.parseInt(fromTo[1], -1);
                    if (from >= 0 && to >= 0 && from < to) {
                        ArrayList<String> ret = new ArrayList<String>();
                        for (int i = from; i <= to; ++i) {
                            if (i >= split.length) continue;
                            ret.add(split[i].strip());
                        }
                        return String.join((CharSequence)", ", ret);
                    }
                }
            } else {
                int idx = MetadataUtil.parseInt(s, -1);
                if (idx >= split.length) {
                    LOGGER.trace("Wanted entry {} greater than what we have splitted: {}", (Object)idx, (Object)split);
                    return o.toString();
                }
                if (idx >= 0) {
                    return split[idx].strip();
                }
            }
        }
        LOGGER.trace("there was nothing to split for index: {} - {}", (Object)s, o);
        return o.toString();
    }

    public String getName() {
        return "split";
    }

    public RenderFormatInfo getFormatInfo() {
        return null;
    }

    public Class<?>[] getSupportedClasses() {
        return new Class[]{String.class};
    }
}

