/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.treetable;

import ca.odell.glazedlists.swing.SortableRenderer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.tree.TmmTreeModel;
import org.tinymediamanager.ui.components.treetable.ITmmTreeTableSortingStrategy;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;

public class TmmTreeTableComparatorChooser {
    private final TmmTreeTable treeTable;
    private final ITmmTreeTableSortingStrategy sortingStrategy;
    private SortArrowHeaderRenderer sortArrowHeaderRenderer;
    private final HeaderClickHandler headerClickHandler;

    public static void install(TmmTreeTable treeTable) {
        new TmmTreeTableComparatorChooser(treeTable);
    }

    private TmmTreeTableComparatorChooser(TmmTreeTable treeTable) {
        this.treeTable = treeTable;
        this.sortingStrategy = (ITmmTreeTableSortingStrategy)((Object)((TmmTreeModel)treeTable.getTreeTableModel().getTreeModel()).getDataProvider().getTreeComparator());
        this.wrapDefaultTableHeaderRenderer();
        this.wrapColumnHeaderRenderer();
        this.headerClickHandler = new HeaderClickHandler(treeTable);
    }

    private void wrapDefaultTableHeaderRenderer() {
        Class<?> defaultRendererType;
        TableCellRenderer defaultRenderer = this.treeTable.getTableHeader().getDefaultRenderer();
        Class<?> clazz = defaultRendererType = defaultRenderer == null ? null : defaultRenderer.getClass();
        if (defaultRendererType != SortArrowHeaderRenderer.class && defaultRendererType != null) {
            this.sortArrowHeaderRenderer = new SortArrowHeaderRenderer(defaultRenderer);
            this.treeTable.getTableHeader().setDefaultRenderer(this.sortArrowHeaderRenderer);
        }
    }

    private void wrapColumnHeaderRenderer() {
        Iterator<TableColumn> columns = this.treeTable.getTableHeader().getColumnModel().getColumns().asIterator();
        while (columns.hasNext()) {
            TableColumn column = columns.next();
            TableCellRenderer columnHeaderRenderer = column.getHeaderRenderer();
            if (columnHeaderRenderer == null || columnHeaderRenderer.getClass() == SortArrowHeaderRenderer.class) continue;
            column.setHeaderRenderer(new SortArrowHeaderRenderer(columnHeaderRenderer));
        }
    }

    private class HeaderClickHandler
    extends MouseAdapter {
        private final JTable table;
        private boolean mouseEventIsPerformingPopupTrigger = false;

        public HeaderClickHandler(TmmTreeTable treeTable) {
            this.table = treeTable;
            treeTable.getTableHeader().addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.mouseEventIsPerformingPopupTrigger) {
                return;
            }
            if (this.table.getTableHeader().getCursor() == Cursor.getPredefinedCursor(11)) {
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            TableColumnModel columnModel = this.table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.table.convertColumnIndexToModel(viewColumn);
            int clicks = e.getClickCount();
            if (clicks >= 1 && column != -1) {
                boolean shift = e.isShiftDown();
                boolean control = e.isControlDown() || e.isMetaDown();
                TmmTreeTableComparatorChooser.this.sortingStrategy.columnClicked(column, shift, control);
                TmmTreeTableComparatorChooser.this.treeTable.updateFiltering();
                TmmTreeTableComparatorChooser.this.treeTable.getTableHeader().repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseEventIsPerformingPopupTrigger = mouseEvent.isPopupTrigger();
        }

        public void dispose() {
            this.table.getTableHeader().removeMouseListener(this);
        }
    }

    class SortArrowHeaderRenderer
    implements TableCellRenderer,
    UIResource {
        private TableCellRenderer delegateRenderer;

        public SortArrowHeaderRenderer(TableCellRenderer delegateRenderer) {
            this.delegateRenderer = delegateRenderer;
        }

        public TableCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendered;
            if (column < 0) {
                return this.getDelegateTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            int modelColumn = table.convertColumnIndexToModel(column);
            Icon sortIcon = this.getSortIcon(modelColumn);
            if (this.delegateRenderer instanceof SortableRenderer) {
                ((SortableRenderer)this.delegateRenderer).setSortIcon(sortIcon);
                rendered = this.getDelegateTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            } else {
                rendered = this.getDelegateTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (rendered instanceof JLabel) {
                    JLabel label = (JLabel)rendered;
                    label.setIcon(sortIcon);
                    label.setHorizontalTextPosition(10);
                }
            }
            return rendered;
        }

        private Icon getSortIcon(int column) {
            ITmmTreeTableSortingStrategy.SortDirection sortDirection = TmmTreeTableComparatorChooser.this.sortingStrategy.getSortDirection(column);
            if (sortDirection == ITmmTreeTableSortingStrategy.SortDirection.ASCENDING) {
                return IconManager.SORT_UP_PRIMARY;
            }
            if (sortDirection == ITmmTreeTableSortingStrategy.SortDirection.DESCENDING) {
                return IconManager.SORT_DOWN_PRIMARY;
            }
            return null;
        }

        private Component getDelegateTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                return this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            catch (RuntimeException e) {
                this.delegateRenderer = new DefaultTableCellRenderer();
                return this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }
    }
}

