/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.util.Date;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public enum TvShowEpisodeType {
    UNCATEGORIZED,
    SPECIAL,
    NORMAL,
    DUMMY_SPECIAL,
    DUMMY_NORMAL,
    DUMMY_NOT_AIRED;


    public static TvShowEpisodeType getTypeForEpisode(TvShowEpisode episode) {
        if (!episode.isDummy()) {
            if (episode.getSeason() < 0 || episode.getEpisode() < 0) {
                return UNCATEGORIZED;
            }
            if (episode.getSeason() == 0) {
                return SPECIAL;
            }
            return NORMAL;
        }
        if (episode.getFirstAired() == null || episode.getFirstAired().compareTo(new Date()) > 0) {
            return DUMMY_NOT_AIRED;
        }
        if (episode.getSeason() == 0) {
            return DUMMY_SPECIAL;
        }
        return DUMMY_NORMAL;
    }
}

