/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.thetvdb.entities.LoginRequestRecord;
import org.tinymediamanager.scraper.thetvdb.entities.LoginResponse;
import org.tinymediamanager.scraper.thetvdb.entities.SeasonType;
import org.tinymediamanager.scraper.thetvdb.service.ConfigService;
import org.tinymediamanager.scraper.thetvdb.service.EpisodesService;
import org.tinymediamanager.scraper.thetvdb.service.LoginService;
import org.tinymediamanager.scraper.thetvdb.service.MoviesService;
import org.tinymediamanager.scraper.thetvdb.service.SearchService;
import org.tinymediamanager.scraper.thetvdb.service.SeasonsService;
import org.tinymediamanager.scraper.thetvdb.service.SeriesService;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class TheTvDbController {
    private static final String API_BASE_URL = "https://api4.thetvdb.com/v4/";
    private Retrofit restAdapter;
    private String userApiKey;
    private String userPin;
    private String authToken;

    public String getUserApiKey() {
        return this.userApiKey;
    }

    public void setUserApiKey(String userApiKey) {
        this.userApiKey = userApiKey;
    }

    public String getUserPin() {
        return this.userPin;
    }

    public void setUserPin(String userPin) {
        this.userPin = userPin;
    }

    private Retrofit getRestAdapter() {
        if (this.restAdapter == null) {
            OkHttpClient.Builder builder = TmmHttpClient.newBuilderWithForcedCache(15, TimeUnit.MINUTES);
            builder.addInterceptor(chain -> {
                Request original = chain.request();
                Request.Builder request = original.newBuilder().method(original.method(), original.body());
                request.addHeader("Authorization", "Bearer " + this.authToken);
                return chain.proceed(request.build());
            });
            this.restAdapter = new Retrofit.Builder().client(builder.build()).baseUrl(API_BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)TheTvDbController.getGsonBuilder().create())).build();
        }
        return this.restAdapter;
    }

    private static GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return -1;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeAdapter(SeasonType.class, (json, typeOfT, context) -> {
            for (SeasonType type : SeasonType.values()) {
                if (!type.toString().equals(json.getAsString())) continue;
                return type;
            }
            return null;
        });
        return builder;
    }

    static String login(String apiKey, String pin) throws Exception {
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            return null;
        }
        OkHttpClient.Builder builder = TmmHttpClient.newBuilder();
        Retrofit retrofit = new Retrofit.Builder().client(builder.build()).baseUrl(API_BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)TheTvDbController.getGsonBuilder().create())).build();
        LoginService loginService = (LoginService)retrofit.create(LoginService.class);
        LoginRequestRecord data = new LoginRequestRecord();
        data.apikey = apiKey;
        data.pin = pin;
        Response response = loginService.login(data).execute();
        String token = null;
        if (response.isSuccessful()) {
            token = ((LoginResponse)response.body()).data.token;
        }
        if (StringUtils.isBlank(token)) {
            throw new HttpException(403, "Unauthorized");
        }
        return token;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public ConfigService getConfigService() {
        return (ConfigService)this.getRestAdapter().create(ConfigService.class);
    }

    public SearchService getSearchService() {
        return (SearchService)this.getRestAdapter().create(SearchService.class);
    }

    public SeriesService getSeriesService() {
        return (SeriesService)this.getRestAdapter().create(SeriesService.class);
    }

    public EpisodesService getEpisodesService() {
        return (EpisodesService)this.getRestAdapter().create(EpisodesService.class);
    }

    public SeasonsService getSeasonsService() {
        return (SeasonsService)this.getRestAdapter().create(SeasonsService.class);
    }

    public MoviesService getMoviesService() {
        return (MoviesService)this.getRestAdapter().create(MoviesService.class);
    }
}

