/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.CLPIWriter;
import org.tinymediamanager.library.bluray.clipinf.ClipInfo;
import org.tinymediamanager.library.bluray.clipinf.ProgramInfo;
import org.tinymediamanager.library.bluray.clipinf.SequenceInfo;
import org.tinymediamanager.library.bluray.clipinf.StringIOHelper;

@XmlRootElement
@XmlType(propOrder={"typeIndicator", "versionNumber", "clipInfo", "sequenceInfo", "programInfo", "cpiLength", "cpi", "cmLength", "edLength", "extensionData"})
public class CLPIObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(CLPIObject.class);
    public static final String TYPE = "HDMV";
    private String typeIndicator;
    private String versionNumber;
    private ClipInfo clipInfo = new ClipInfo();
    private SequenceInfo sequenceInfo = new SequenceInfo();
    private ProgramInfo programInfo = new ProgramInfo();
    private int cpiLength;
    private byte[] cpi = null;
    private int cmLength = 0;
    private int edLength = 0;
    private byte[] extensionData = null;

    public String getTypeIndicator() {
        return this.typeIndicator;
    }

    public void setTypeIndicator(String string) {
        this.typeIndicator = string;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String string) {
        this.versionNumber = string;
    }

    @XmlElement(name="ClipInfo")
    public ClipInfo getClipInfo() {
        return this.clipInfo;
    }

    public void setClipInfo(ClipInfo clipInfo) {
        this.clipInfo = clipInfo;
    }

    @XmlElement(name="SequenceInfo")
    public SequenceInfo getSequenceInfo() {
        return this.sequenceInfo;
    }

    public void setSequenceInfo(SequenceInfo sequenceInfo) {
        this.sequenceInfo = sequenceInfo;
    }

    @XmlElement(name="ProgramInfo")
    public ProgramInfo getProgramInfo() {
        return this.programInfo;
    }

    public void setProgramInfo(ProgramInfo programInfo) {
        this.programInfo = programInfo;
    }

    public int getCpiLength() {
        return this.cpiLength;
    }

    public void setCpiLength(int n) {
        this.cpiLength = n;
    }

    public byte[] getCpi() {
        return this.cpi;
    }

    public void setCpi(byte[] byArray) {
        this.cpi = byArray;
    }

    public int getCmLength() {
        return this.cmLength;
    }

    public void setCmLength(int n) {
        this.cmLength = n;
    }

    public int getEdLength() {
        return this.edLength;
    }

    public void setEdLength(int n) {
        this.edLength = n;
    }

    public byte[] getExtensionData() {
        return this.extensionData;
    }

    public void setExtensionData(byte[] byArray) {
        this.extensionData = byArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        this.typeIndicator = StringIOHelper.readISO646String(dataInputStream, 4);
        LOGGER.trace("typeIndicator={}", (Object)this.typeIndicator);
        this.versionNumber = StringIOHelper.readISO646String(dataInputStream, 4);
        LOGGER.trace("versionNumber={}", (Object)this.versionNumber);
        int n = dataInputStream.readInt();
        LOGGER.trace("sequenceInfoStartAddress={}", (Object)n);
        int n2 = dataInputStream.readInt();
        LOGGER.trace("programInfoStartAddress={}", (Object)n2);
        int n3 = dataInputStream.readInt();
        LOGGER.trace("cpiStartAddress={}", (Object)n3);
        int n4 = dataInputStream.readInt();
        LOGGER.trace("clipMarkStartAddr={}", (Object)n4);
        int n5 = dataInputStream.readInt();
        LOGGER.trace("extDataStartAddr={}", (Object)n5);
        dataInputStream.skipBytes(12);
        this.clipInfo.readObject(dataInputStream);
        int n6 = 40 + this.clipInfo.size();
        LOGGER.trace("sequenceInfoPosition={} skipping {}", (Object)n6, (Object)(n - n6));
        if (n > n6) {
            dataInputStream.skipBytes(n - n6);
        }
        this.sequenceInfo.readObject(dataInputStream);
        n6 = n + this.sequenceInfo.size();
        LOGGER.trace("programInfoPosition={} skipping {}", (Object)n6, (Object)(n2 - n6));
        if (n2 > n6) {
            dataInputStream.skipBytes(n2 - n6);
        }
        this.programInfo.readObject(dataInputStream);
        n6 = n2 + this.programInfo.size();
        if (n3 > n6) {
            dataInputStream.skipBytes(n3 - n6);
        }
        LOGGER.trace("cpiPosition={} skipping {}", (Object)n6, (Object)(n3 - n6));
        this.cpiLength = dataInputStream.readInt();
        LOGGER.trace("cpiLength={}", (Object)this.cpiLength);
        if (this.cpiLength > 0) {
            this.cpi = new byte[this.cpiLength];
            dataInputStream.read(this.cpi, 0, this.cpiLength);
        }
        n6 = n3 + this.cpiLength + 4;
        LOGGER.trace("clipMarkPosition={} skipping {}", (Object)n6, (Object)(n4 - n6));
        if (n4 > n6) {
            dataInputStream.skipBytes(n4 - n6);
        }
        this.cmLength = dataInputStream.readInt();
        LOGGER.trace("cmLength={}", (Object)this.cmLength);
        n6 = n4 + this.cmLength + 4;
        LOGGER.trace("extensionDataPosition={} skipping {}", (Object)n6, (Object)(n5 - n6));
        if (n5 > n6) {
            dataInputStream.skipBytes(n5 - n6);
        }
        if (n5 > 0) {
            this.edLength = dataInputStream.readInt();
            LOGGER.trace("edLength={}", (Object)this.edLength);
            if (this.edLength > 0) {
                this.extensionData = new byte[this.edLength];
                dataInputStream.read(this.extensionData, 0, this.edLength);
            }
        }
    }

    public String toXML() {
        OutputStream outputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            outputStream = new DataOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            new CLPIWriter().writeXml(this, outputStream);
            ((FilterOutputStream)outputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            outputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            this.writeObject(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream2);
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream4 = new DataOutputStream(byteArrayOutputStream3);
        ByteArrayOutputStream byteArrayOutputStream4 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream5 = new DataOutputStream(byteArrayOutputStream4);
        this.clipInfo.writeObject(dataOutputStream2);
        LOGGER.trace("streamClipInfo={}", (Object)dataOutputStream2.size());
        if (dataOutputStream2.size() % 4 != 0) {
            dataOutputStream2.writeShort(0);
        }
        dataOutputStream2.flush();
        dataOutputStream2.close();
        this.sequenceInfo.writeObject(dataOutputStream3);
        LOGGER.trace("streamSequenceInfo={}", (Object)dataOutputStream3.size());
        if (dataOutputStream3.size() % 4 != 0) {
            dataOutputStream3.writeShort(0);
        }
        dataOutputStream3.flush();
        dataOutputStream3.close();
        this.programInfo.writeObject(dataOutputStream4);
        LOGGER.trace("streamProgramInfo={}", (Object)dataOutputStream4.size());
        if (dataOutputStream4.size() % 4 != 0) {
            dataOutputStream4.writeShort(0);
        }
        dataOutputStream4.flush();
        dataOutputStream4.close();
        dataOutputStream5.writeInt(this.cpiLength);
        if (this.cpiLength > 0) {
            dataOutputStream5.write(this.cpi, 0, this.cpiLength);
        }
        LOGGER.trace("streamCpi={}", (Object)dataOutputStream5.size());
        if (dataOutputStream5.size() % 4 != 0) {
            dataOutputStream5.writeShort(0);
        }
        dataOutputStream5.flush();
        dataOutputStream5.close();
        int n = 40 + byteArrayOutputStream.size();
        int n2 = n + byteArrayOutputStream2.size();
        int n3 = n2 + byteArrayOutputStream3.size();
        int n4 = n3 + byteArrayOutputStream4.size();
        int n5 = n4 + 4;
        if (this.edLength == 0) {
            n5 = 0;
        }
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getTypeIndicator()));
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getVersionNumber()));
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeInt(n5);
        for (int i = 0; i < 12; ++i) {
            dataOutputStream.write(0);
        }
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
        dataOutputStream.write(byteArrayOutputStream2.toByteArray());
        dataOutputStream.write(byteArrayOutputStream3.toByteArray());
        dataOutputStream.write(byteArrayOutputStream4.toByteArray());
        dataOutputStream.writeInt(this.cmLength);
        if (n5 > 0) {
            dataOutputStream.writeInt(this.edLength);
            dataOutputStream.write(this.extensionData);
        }
    }
}

